import React from 'react'
import {
  Row,
  Col,
  Upload,
  message,
  Divider
  // Slider
} from 'antd'
import {
  uploadParamsGen,
  beforeUploadGen,
  uploadStatusChangeGen
} from 'layersWp/config'
import { get } from 'lodash-es'
import { getNetUrl, readImageProps } from 'layersWp/utils/helper'
import styles from './index.less'
import { observer } from 'mobx-react'

@observer
class CardEditor extends React.Component {
  render() {
    const { label, filed, dpr, handleChange, target } = this.props
    console.log(get(target, `${filed}.opacity`))
    return (
      <div>
        <Divider />
        <Row>
          <Col offset={1}>{label}</Col>
        </Row>
        <Row>
          <Col span={10} offset={1}>
            <Upload
              {...{
                ...uploadParamsGen(),
                beforeUpload: beforeUploadGen({
                  pixel: {
                    width: 230
                  }
                }),
                showUploadList: false,
                onChange: uploadStatusChangeGen(info => {
                  if (info.file.status === 'done') {
                    const netUrl = getNetUrl(info.file.name)
                    handleChange({
                      [`${filed}.backImage`]: netUrl
                    })
                  } else if (info.file.status === 'error') {
                    message.error(`${info.file.name}。文件上传失败`)
                  }
                })
              }}
            >
              <img
                className={styles.uploader}
                src={get(target, `${filed}.backImage`, '')}
                alt=""
              />
            </Upload>
            <div style={{ textAlign: 'center', fontSize: 12 }}>翻转前</div>
          </Col>
          <Col span={10} offset={1}>
            <Upload
              {...{
                ...uploadParamsGen(),
                beforeUpload: beforeUploadGen({
                  pixel: {
                    width: 230
                  }
                }),
                showUploadList: false,
                onChange: uploadStatusChangeGen(info => {
                  if (info.file.status === 'done') {
                    const netUrl = getNetUrl(info.file.name)
                    handleChange({
                      [`${filed}.frontImage`]: netUrl
                    })
                    // resize图片尺寸
                    readImageProps(netUrl).then(res => {
                      handleChange({
                        [`${filed}.height`]: res.height / dpr + 'px'
                      })
                    })
                  } else if (info.file.status === 'error') {
                    message.error(`${info.file.name}。文件上传失败`)
                  }
                })
              }}
            >
              <img
                className={styles.uploader}
                src={get(target, `${filed}.frontImage`, '')}
                alt=""
              />
            </Upload>
            <div style={{ textAlign: 'center', fontSize: 12 }}>翻转后</div>
          </Col>
        </Row>
        {/* <Row type="flex" align="middle">
          <Col span={4} offset={1}>
            透明度
          </Col>
          <Col span={10} offset={1}>
            <Slider
              value={get(target, `${filed}.opacity`) * 100}
              step={10}
              min={0}
              max={100}
              onChange={value =>
                handleChange({ [`${filed}.opacity`]: value / 100 })
              }
            />
          </Col>
        </Row> */}
      </div>
    )
  }
}
export default CardEditor
