import React, { Component } from 'react'
import Item from 'layersWp/constructors/item/index'
import ItemsStyle from '../items.less'
import { FixedImage as Type } from 'layersWp/utils/itemType'
import defaultAttrs from './attrs'
import { ImageScreenshot as Screenshot } from 'layersWp/config/dragScreenshot'
import TuiaIcon from 'layersWp/constructors/fc/icon'
import store from 'layersWp/store'
@Item({
  type: Type,
  defaultAttrs: defaultAttrs,
  screenshot: Screenshot,
  onDragIntoScene({ targetId }) {
    store.WPLayersStore.changeItemPropsById(targetId, {
      'style.left': '0px',
      'style.top': '0px'
    })
  }
})
export default class FixedImageItem extends Component {
  render() {
    return (
      <div className={ItemsStyle['item']}>
        <TuiaIcon type="control_photo" />
        悬浮图片
      </div>
    )
  }
}
