import React, { Component } from 'react'
import { Form, Tabs, Row, Col, Input, Upload, message, Switch } from 'antd'
import styles from '../edits.less'
import { CodeType as type } from 'layersWp/utils/itemType'
import Editor from 'layersWp/constructors/editor/index'
import { observer, inject } from 'mobx-react'
import { formItemProps } from '../helper'
import CodeModal from './codeEditor'
import ConfigModal from './configEditor'
import { unset, isEmpty } from 'lodash-es'
import {
  readImageProps,
  getNumber,
  getNetUrl,
  getUrlFromBackgroundImage
} from 'layersWp/utils/helper'
import {
  uploadParamsGen,
  beforeUploadGen,
  uploadStatusChangeGen,
  staticResourcePrefix
} from 'layersWp/config'
import defaultAttrs from './attrs'

const TabPane = Tabs.TabPane
const FormItem = Form.Item

@Editor({
  type,
  basic: {
    jump: {
      options: [
        {
          label: '无',
          value: 'none'
        }
      ],
      nonPopup: 1,
      force: 1
    }
  },
  attrs: defaultAttrs
})
@inject('WPLayersStore')
@observer
export default class CodeEditor extends Component {
  render() {
    const {
      target,
      BasicAttrsCom,
      handleChange,
      WidgetNameCom,
      JumpCom,
      EventCom,
      ActionCom
    } = this.props
    const ImageStyle = Object.assign({}, target.style, {
      maxWidth: '100%',
      maxHeight: '100%'
    })
    unset(ImageStyle, 'width')
    unset(ImageStyle, 'height')
    unset(ImageStyle, 'top')
    unset(ImageStyle, 'left')
    unset(ImageStyle, 'position')
    unset(ImageStyle, 'cursor')
    return (
      <div className={styles.edit}>
        <Tabs defaultActiveKey="1" style={{ height: '100%' }}>
          <TabPane tab="代码" key="1">
            <Form layout="inline">
              <Row style={{ marginBottom: '8px' }}>
                <Col offset={1} span={22}>
                  {WidgetNameCom}
                </Col>
              </Row>
              <Row>
                <Col offset={1} span={22}>
                  <div
                    className={styles['uploader']}
                    style={{
                      backgroundImage: `url("${staticResourcePrefix}/masker@2x.png")`
                    }}
                  >
                    <Upload
                      {...{
                        ...uploadParamsGen(),
                        beforeUpload: beforeUploadGen(),
                        showUploadList: false,
                        onChange: uploadStatusChangeGen(info => {
                          if (info.file.status === 'done') {
                            const netUrl = getNetUrl(info.file.name)
                            const { dpr } = this.props.WPLayersStore.scene
                            handleChange({
                              'style.backgroundImage': `url("${netUrl}")`
                            })
                            // resize图片尺寸
                            readImageProps(netUrl).then(res => {
                              handleChange({
                                'style.width': res.width / dpr + 'px',
                                'style.height': res.height / dpr + 'px'
                              })
                            })
                          } else if (info.file.status === 'error') {
                            message.error(`${info.file.name}。文件上传失败`)
                          }
                        })
                      }}
                    >
                      <img
                        src={ImageStyle.backgroundImage.replace(
                          /url\("([\s\S]*)"\)/,
                          (_, matches) => matches
                        )}
                        style={ImageStyle}
                      />
                    </Upload>
                  </div>
                </Col>
              </Row>
              <FormItem label="代码包" {...formItemProps}>
                <CodeModal
                  target={target}
                  handleChange={handleChange}
                />
              </FormItem>
              <FormItem label="图片包" {...formItemProps}>
                {isEmpty(target.code.config) ? (
                  ''
                ) : (
                  <ConfigModal
                    target={target}
                    handleChange={handleChange}
                  />
                )}
              </FormItem>
              <FormItem label="初始隐藏" {...formItemProps}>
                <Switch defaultChecked checked={target.code.hide} onChange={value => {
                  handleChange({
                    'code.hide': value
                  })
                }} />
              </FormItem>
              {JumpCom}
            </Form>
          </TabPane>
          {/* <TabPane tab="事件" key="2">
            {EventCom}
          </TabPane> */}
          <TabPane tab="行为" key="3">
            {ActionCom}
          </TabPane>
        </Tabs>
      </div>
    )
  }
}
