import React, { Component } from 'react'
import {
  Form,
  Input,
  Tabs,
  InputNumber,
  Select,
  Row,
  Col,
  Upload,
  message
} from 'antd'
import styles from '../edits.less'
import commonStyles from 'layersWp/config/commonStyle'
import ButtonEditStyles from './index.less'
import ColorPicker from 'layers/components/color-picker/index'
import { formItemProps, pxFormatter } from '../helper'
import {
  readImageProps,
  getNumber,
  getNetUrl,
  getUrlFromBackgroundImage
} from 'layersWp/utils/helper'
import { ButtonType } from 'layersWp/utils/itemType'
import {
  uploadParamsGen,
  beforeUploadGen,
  uploadStatusChangeGen,
  staticResourcePrefix
} from 'layersWp/config'
import editor from 'layersWp/constructors/editor/index'
import { inject, observer } from 'mobx-react'
import cn from 'classnames'
import defaultAttrs from './attrs'

const FormItem = Form.Item
const TabPane = Tabs.TabPane
const Option = Select.Option

@editor({
  type: ButtonType,
  basic: {
    jump: {
      hideNone: 1
    }
  },
  attrs: defaultAttrs
})
@inject('WPLayersStore')
@observer
export default class ButtonEditor extends Component {
  handleFastStyleClick = (props, borderRadius, index) => {
    props.handleChange({
      'style.borderBottomLeftRadius': borderRadius,
      'style.borderBottomRightRadius': borderRadius,
      'style.borderTopLeftRadius': borderRadius,
      'style.borderTopRightRadius': borderRadius,
      'style.backgroundImage': '',
      'multiStyle.click.backgroundImage': '',
      'style.width': '240px',
      'style.height': '38px',
      'style.backgroundColor': '#EA5422',
      text: '立即领取',
      styleMode: index,
      'animation.duration': 0
    })
  }

  handleBtnClick = props => {
    props.handleChange({
      'style.borderBottomLeftRadius': 0,
      'style.borderBottomRightRadius': 0,
      'style.borderTopLeftRadius': 0,
      'style.borderTopRightRadius': 0,
      text: '',
      'style.backgroundColor': 'transparent',
      'style.backgroundImage':
        'url("//yun.dui88.com/jimu-web/5bfce0d91c9d448b647921b8.png")',
      styleMode: 3
    })
  }

  render() {
    const {
      handleChange,
      target,
      BasicAttrsCom,
      WidgetNameCom,
      FixedAttrCom,
      JumpCom,
      AnimationCom,
      EventCom,
      ActionCom
    } = this.props
    const { styleMode } = target
    const { dpr } = this.props.WPLayersStore.scene
    return (
      <div className={styles.edit}>
        <Tabs defaultActiveKey="1" style={{ height: '100%' }}>
          <TabPane tab="按钮" key="1">
            <Form layout="inline">
              <Row style={{ marginBottom: '8px' }}>
                <Col offset={1} span={22}>
                  {WidgetNameCom}
                </Col>
              </Row>
              <FormItem label="快捷样式" {...formItemProps}>
                <Row type="flex" justify="space-around" align="middle">
                  {(() =>
                    [0, 8, 32].map((item, index) => {
                      return (
                        <Col style={{ width: 40 }} key={index}>
                          <div
                            className={ButtonEditStyles['fastStyle']}
                            onClick={this.handleFastStyleClick.bind(
                              this,
                              this.props,
                              `${item}px`,
                              index
                            )}
                            style={{
                              backgroundImage: `url(${staticResourcePrefix}/radius-${item}px.svg)`,
                              backgroundSize: 'cover',
                              borderColor:
                                styleMode === index
                                  ? commonStyles['@primary-color']
                                  : commonStyles['@primary-border-color']
                            }}
                          />
                        </Col>
                      )
                    }))()}
                  <Col style={{ width: '60px' }}>
                    <div
                      className={cn(ButtonEditStyles.uploadBtn, {
                        [ButtonEditStyles.active]: styleMode === 3
                      })}
                      onClick={this.handleBtnClick.bind(this, this.props)}
                    >
                      上传按钮
                    </div>
                  </Col>
                </Row>
              </FormItem>
              {styleMode === 3 ? (
                <React.Fragment>
                  {genUploadBtn(
                    getUrlFromBackgroundImage(target.style.backgroundImage),
                    uploadStatusChangeGen(info => {
                      if (info.file.status === 'done') {
                        const netUrl = getNetUrl(info.file.name)
                        const { dpr } = this.props.WPLayersStore.scene
                        this.props.handleChange({
                          'style.backgroundImage': `url("${netUrl}")`
                        })
                        // resize图片尺寸
                        readImageProps(netUrl).then(res => {
                          this.props.handleChange({
                            'style.width': res.width / dpr + 'px',
                            'style.height': res.height / dpr + 'px'
                          })
                        })
                      }
                    })
                  )}
                  {genUploadBtn(
                    getUrlFromBackgroundImage(
                      target.multiStyle.click.backgroundImage
                    ),
                    uploadStatusChangeGen(info => {
                      if (info.file.status === 'done') {
                        handleChange({
                          'multiStyle.click.backgroundImage': `url("${getNetUrl(
                            info.file.name
                          )}")`
                        })
                      } else if (info.file.status === 'error') {
                        message.error(`${info.file.name}。文件上传失败`)
                      }
                    })
                  )}
                  {/* <FormItem label="动态设置" {...formItemProps}>
                    <Select
                      value={target.animation.duration}
                      onChange={value =>
                        handleChange({ 'animation.duration': value })
                      }
                    >
                      <Option value={0}>无</Option>
                      <Option value={600}>缓慢</Option>
                      <Option value={400}>适中</Option>
                      <Option value={200}>快速</Option>
                    </Select>
                  </FormItem> */}
                  {AnimationCom}
                </React.Fragment>
              ) : (
                <React.Fragment>
                  <FormItem label="按钮文字" {...formItemProps}>
                    <Input
                      placeholder="请输入按钮名称"
                      value={target.text}
                      onChange={e => handleChange({ text: e.target.value })}
                    />
                  </FormItem>
                  <FormItem label="按钮颜色" {...formItemProps}>
                    <Row type="flex" justify="center" align="middle">
                      <Col span={6}>
                        <ColorPicker
                          value={target.style.backgroundColor}
                          onChange={color =>
                            handleChange({ 'style.backgroundColor': color })
                          }
                        />
                      </Col>
                      <Col offset={4} span={8} style={{ textAlign: 'center' }}>
                        文字颜色
                      </Col>
                      <Col span={6}>
                        <ColorPicker
                          value={target.style.color}
                          onChange={color =>
                            handleChange({ 'style.color': color })
                          }
                        />
                      </Col>
                    </Row>
                  </FormItem>
                  <FormItem label="字号" {...formItemProps}>
                    <InputNumber
                      value={getNumber(target.style.fontSize) * dpr}
                      formatter={pxFormatter.formatter}
                      parser={pxFormatter.parser}
                      style={{ width: '64px' }}
                      onChange={value =>
                        handleChange({ 'style.fontSize': value / dpr })
                      }
                    />
                  </FormItem>
                </React.Fragment>
              )}
              <FormItem label="图案验证" {...formItemProps}>
                <Select
                  value={target.picValid}
                  onChange={value => handleChange({ picValid: value })}
                >
                  <Option value={1}>是</Option>
                  <Option value={0}>否</Option>
                </Select>
              </FormItem>
              <div style={{ marginBottom: 8 }} />
              {BasicAttrsCom}
              {FixedAttrCom}
            </Form>
          </TabPane>
          <TabPane tab="点击" key="2">
            {JumpCom}
          </TabPane>
          <TabPane tab="事件" key="3">
            {EventCom}
          </TabPane>
          <TabPane tab="行为" key="4">
            {ActionCom}
          </TabPane>
        </Tabs>
      </div>
    )
  }
}

function genUploadBtn(value, onChange) {
  return (
    <Row>
      <Col offset={1} span={22}>
        <Upload
          {...{
            ...uploadParamsGen(),
            listType: 'picture-card',
            showUploadList: false,
            className: 'button-click-background-uploader',
            beforeUpload: beforeUploadGen(),
            onChange
          }}
        >
          {value ? (
            <div
              style={{
                width: '100%',
                height: '100%',
                backgroundColor: '#fff',
                display: 'flex',
                justifyContent: 'center',
                alignItems: 'center'
                // backgroundImage: `url("${staticResourcePrefix}/masker@2x.png")`
              }}
            >
              <img
                src={value}
                style={{ maxWidth: '100%', maxHeight: '80px' }}
              />
            </div>
          ) : (
            <div>
              <div
                style={{
                  fontSize: commonStyles['@secondary-sys-font-size'],
                  color: commonStyles['@third-font-color'],
                  fontWeight: 'bold'
                }}
              >
                上传点击后按钮图片
              </div>
              <div
                style={{
                  fontSize: commonStyles['@third-sys-icon-size'],
                  color: commonStyles['@third-font-color']
                }}
              >
                支持格式：JPG/PNG/GIF
              </div>
              <div
                style={{
                  fontSize: commonStyles['@third-sys-icon-size'],
                  color: commonStyles['@third-font-color']
                }}
              >
                文件大小：&lt; 500K
              </div>
            </div>
          )}
        </Upload>
      </Col>
    </Row>
  )
}
