import { hashHistory } from 'react-router'
import { setLocalStorage } from 'layersWp/utils/helper'
import { bodyInnerUniqueId } from 'layersWp/config'

export const jumpActionsMapping = {
  // 使用模版
  USE_TEMPLATE: 'USE_TEMPLATE',
  // 编辑模版
  EDIT_TEMPLATE: 'EDIT_TEMPLATE',
  // 编辑弹层
  EDIT_LAYER: 'EDIT_LAYER',
  // 创建弹层
  CREATE_LAYER: 'CREATE_LAYER',
  // 复制弹层
  COPY_LAYER: 'COPY_LAYER'
}
export const jumpIntoWorkplace = function jumpIntoWorkplace(
  id = 54,
  action = jumpActionsMapping.CREATE_LAYER,
  skin
) {
  return new Promise(resolve => {
    setLocalStorage('pageId', id)
    setLocalStorage('jumpAction', action)
    setLocalStorage('skin', skin)
    hashHistory.push('/workplace')
    resolve()
  })
}

export const workplaceGoTop = function workplaceGoTop() {
  const raf = window.requestAnimationFrame || window.webkitRequestAnimationFrame
  let dom = document.querySelector(`#${bodyInnerUniqueId}`)
  let animate = () => {
    if (dom.scrollTop <= 0) {
      window.dispatchEvent(new window.Event('resize'))
      return false
    } else {
      dom.scrollTop -= 90
      raf(animate)
    }
  }
  raf(animate)
}
