import { action, observable } from 'mobx'
import { setLocalStorage, getLocalStorage, removeLocalStorage } from 'layersWp/utils/helper'
import { snapshotGen } from 'layersWp/constructors/other-default'
import HookStore from './hook'

class Snapshot {
  // 目前监控的动作有修改dpr，修改scene，itemList或者widget属性，editingTarget
  @observable
  snapshot = snapshotGen()
  snapshotCallbacks = []
  Dep = {}
  addDep = dep => {
    Object.keys(dep).forEach(key => (this.Dep[key] = dep[key]))
  }

  // 重置store
  @action
  reset = () => {
    this.snapshot = snapshotGen()
    this.Dep = {}
    this.snapshotCallbacks = []
  }

  @action
  callSnapshotQueue = () => {
    HookStore.walkHooks('onSnapshotEnd')
  }
  @action
  changeSnapshot = step => {
    let existSnapshotQueue = []
    const { type } = this.snapshot
    const ls = window.localStorage
    for (let i = 0; i < ls.length; i++) {
      if (ls.key(i).indexOf(type) !== -1) {
        existSnapshotQueue.push(ls.key(i))
      }
    }
    // !这里的算法要注意，数组的实际索引最大值是total - 1
    const totalIndexLength = this.snapshot.total - 1
    if (
      (step > 0 && this.snapshot.currIndex + step <= totalIndexLength) ||
      (step < 0 && this.snapshot.currIndex + step >= 0)
    ) {
      this.snapshot.currIndex += step
      let obj = getLocalStorage(existSnapshotQueue[this.snapshot.currIndex])
      Object.keys(this.Dep).forEach(name => {
        Object.assign(this.Dep[name].target, obj[name])
      })
    }
    this.callSnapshotQueue()
  }
  addSnapshot = () => {
    if (Object.keys(this.Dep).length === 0) return
    const ls = window.localStorage
    const { type, divider } = this.snapshot
    // 快照队列
    let existSnapshotQueue = []
    for (let i = 0; i < ls.length; i++) {
      if (ls.key(i).indexOf(type) !== -1) {
        const seq = ls
          .key(i)
          .split(divider)
          .pop()
        seq && existSnapshotQueue.push(Number(seq))
      }
    }
    const last = existSnapshotQueue.length === 0 ? 0 : Math.max.apply(null, existSnapshotQueue)
    const prev = Math.min.apply(null, existSnapshotQueue)
    let snapshot = {}
    // 收集依赖
    Object.keys(this.Dep).forEach(namespace => {
      const name = namespace
      const target = this.Dep[name].target
      const keys = this.Dep[name].keys
      snapshot[name] = {}
      keys.forEach(key => {
        snapshot[name][key] = target[key]
      })
    })
    if (existSnapshotQueue.length >= this.snapshot.limit) {
      // 移除队首快照
      removeLocalStorage(`${type}${divider}${prev}`, snapshot)
      this.snapshot.currIndex = this.snapshot.limit - 1
    } else {
      // 修改快照系统状态
      this.snapshot.total = this.snapshot.total + 1
      this.snapshot.currIndex = this.snapshot.currIndex + 1
    }
    // 添加队尾快照
    setLocalStorage(`${type}${divider}${last + 1}`, snapshot)
    HookStore.walkHooks('onAddSnapshot')
  }
}

export default new Snapshot()
