import { action } from 'mobx'

class HookStore {
  // 如继续保存则必须返回true
  onBeforeSave = []
  onAfterSave = []
  // 场景宽高属性变化
  onSceneInnerHeightChangeStart = []
  onSceneInnerHeightChangeEnd = []
  onSceneInnerWidthChangeStart = []
  onSceneInnerWidthChangeEnd = []
  // 初始化数据
  onInit = []
  // 场景keyup事件
  onSceneKeyup = []
  // 场景keydown事件
  onSceneKeydown = []
  // 撤销与重做事件
  onSnapshotEnd = []
  // 存储快照事件
  onAddSnapshot = []

  @action
  addHook (name, handler) {
    if (typeof handler === 'function') {
      this[name].push(handler)
      return () => {
        const index = this[name].findIndex(item => item === handler)
        this[name].splice(index, 1)
      }
    }
  }

  @action
  walkHooks (name, params = {}, async = true) {
    if (async) {
      return Promise.all(this[name].map(hook => {
        return Promise.resolve(params).then(hook)
      }))
    } else {
      this[name].forEach(hook => hook(params))
    }
  }
}

export default new HookStore()
