import React, { Component } from 'react'
import { Dropdown, Menu, message } from 'antd'
import { inject, observer } from 'mobx-react'
import { action, toJS } from 'mobx'
import styles from './index.less'
import {
  deepClone,
  getLocalStorage,
  setLocalStorage,
  dataURLtoFile,
  uploadFile
} from 'layersWp/utils/helper'
import snapshotStore from 'layersWp/store/snapshot'
import hookStore from 'layersWp/store/hook'
import TuiaIcon from 'layersWp/constructors/fc/icon'
import { saveJson, editJson, editTemplate } from 'layersWp/api'
import cn from 'classnames'
import { hashHistory } from 'react-router'
import PreviewH5 from 'components/preview-h5'
import ExitNotify from 'layers/components/exit-notify'
import html2canvas from '@tuia/html2canvas'
import { sceneUniqueId } from 'layersWp/config'
// import { ButtonType, DownloadType } from 'layersWp/utils/itemType'
import { version } from 'layers/version.json'
import { jumpActionsMapping } from 'layersWp/utils/util'
const {
  COPY_LAYER,
  USE_TEMPLATE,
  EDIT_TEMPLATE,
  EDIT_LAYER,
  CREATE_LAYER
} = jumpActionsMapping
@inject('WPLayersStore')
@observer
export default class Header extends Component {
  constructor(props) {
    super(props)
    this.state = {
      modalVisible: false,
      isModify: false,
      // pageId
      pageId: null,
      isSaving: false
    }
  }
  handleDelete(props) {
    action(props.WPLayersStore.removeCurrItem)()
  }
  goBack() {
    hashHistory.push('/template')
  }
  saveAndGoBack = () => {
    this.save(true).then(this.goBack)
  }
  savePreview = sreenshot => {
    return new Promise((resolve, reject) => {
      if (!sreenshot) return resolve()
      return html2canvas(document.getElementById(sceneUniqueId), {
        useCORS: true,
        logging: false
      }).then(canvas => {
        document.getElementById('__body_inner__').appendChild(canvas)
        let dataUrl = canvas.toDataURL()
        let file = dataURLtoFile(dataUrl, 'preview.jpg')
        return uploadFile(file)
          .then(res => {
            if (res.data) {
              resolve(res.data)
            }
          })
          .catch(err => {
            reject(err)
          })
      })
    })
  }
  save = (sreenshot = false) => {
    return new Promise((resolve, reject) => {
      // 校验名称标题
      const { name, code } = this.props.WPLayersStore.scene
      const { skinTags } = this.props.WPLayersStore
      if (!name) {
        message.warn('弹层名称必填')
        return reject(new Error('弹层名称必填'))
      }
      if (name.length > 15) {
        message.warn('弹层名称不超过15个字符')
        return reject(new Error('弹层名称不超过15个字符'))
      }
      console.log(code)
      // 校验自定义代码(组件交互功能)是否符合规范(包含:1.正确的组件ID(必须包含组件ID) 2.组件交互只能是同一场景下的组件)
      // if (code !== undefined && code !== '') {
      //   let countNum = {}
      //   this.props.WPLayersStore.layerList.map(layer => {
      //     countNum[layer.layerId] = 0
      //     layer.itemList.map(item => {
      //       console.log(code.indexOf(item.targetId))
      //       code.indexOf(item.targetId) >= 0 && countNum[layer.layerId]++
      //     })
      //   })
      //   if (Object.values(countNum).filter(item => item === 0).length === Object.values(countNum).length) {
      //     message.warn('多组件交互自定义代码必须包含正确的组件ID')
      //     return reject(new Error('多组件交互自定义代码必须包含正确的组件ID'))
      //   } else if (Object.values(countNum).filter(item => item > 0).length > 1) {
      //     message.warn('多组件交互自定义代码目前只支持同一场景的组件交互')
      //     return reject(new Error('多组件交互自定义代码目前只支持同一场景的组件交互'))
      //   }
      // }

      // 执行onBeforeSave钩子
      let length = hookStore.onBeforeSave.length
      for (let i = 0; i < length; i++) {
        if (!hookStore.onBeforeSave[i]) return
      }
      const { scene, layerList, skinDesc } = this.props.WPLayersStore

      let hasBilling = layerList[0].itemList.some(item => {
        let target = item[item.widgetType]
        return (
          target.jump && target.jump.type !== 'none' && target.jump.isBilling
        )
      })
      if (!hasBilling) {
        message.warn('主场景至少设置一个计费点击')
        return reject(new Error('主场景至少设置一个计费点击'))
      }
      if (!skinTags.length) {
        message.warn('请选择一个标签')
        return reject(new Error('请选择一个标签'))
      }
      let output = {}
      output.version = version
      output.page = deepClone(scene)
      output.layers = layerList.map(layer => ({
        name: layer.name,
        layerId: layer.layerId,
        isMain: layer.isMain,
        autoJump: toJS(layer.autoJump),
        elements: deepClone(layer.itemList.map(item => item[item.widgetType]))
      }))

      if (this.state.isSaving) return
      this.setState({
        isSaving: true
      })
      console.log(JSON.stringify(output), output)
      const pageId = getLocalStorage('pageId')
      const jumpAction = getLocalStorage('jumpAction')
      const edit = (meta, output, thumbnailUrl) => {
        editJson(meta, output, thumbnailUrl).then(res => {
          if (res) {
            message.success('保存成功', 1).then(resolve)
            // 缓存当前配置的id
            const pageId = res.data.id
            setLocalStorage('pageId', pageId)
            this.setState({
              pageId: pageId
            })
          } else {
            message.error(res.errormsg)
            reject(res.errormsg)
          }
          this.setState({
            isModify: false
          })
        })
      }
      this.savePreview(true)
        .then(thumbnailUrl => {
          switch (jumpAction) {
            case CREATE_LAYER:
            case COPY_LAYER:
            case USE_TEMPLATE:
              saveJson({ tagIds: skinTags }, output, thumbnailUrl).then(res => {
                if (res) {
                  message.success('保存成功', 1).then(resolve)
                  // 缓存当前配置的id
                  const pageId = res.data.id
                  setLocalStorage('pageId', pageId)
                  // 创建成功后，变为编辑模式
                  setLocalStorage('jumpAction', EDIT_LAYER)
                  this.setState({
                    pageId: pageId
                  })
                } else {
                  message.error(res.errormsg)
                  reject(res.errormsg)
                }
                this.setState({
                  isSaving: false
                })
              })
              break
            case EDIT_LAYER:
              edit({ id: pageId, tagIds: skinTags }, output, thumbnailUrl).then(
                () => {
                  message.success('保存成功', 1)
                  this.setState({
                    isSaving: false
                  })
                }
              )
              break

            case EDIT_TEMPLATE:
              editTemplate(
                { id: pageId, tagIds: skinTags },
                output,
                thumbnailUrl,
                skinDesc
              ).then(res => {
                message.success('保存成功', 1)
                this.setState({
                  isSaving: false
                })
              })
              break
          }
        })
        .catch(err => {
          console.log(err)
          this.setState({
            isSaving: false
          })
        })
      this.setState({
        isModify: false
      })
    })
  }
  componentDidMount() {
    // 撤销与重做事件订阅
    this.remover = hookStore.addHook('onAddSnapshot', () => {
      if (snapshotStore.snapshot.total > 1) {
        this.setState({
          isModify: true
        })
      }
    })
  }
  componentWillUnmount() {
    this.remover && this.remover()
  }
  render() {
    const { editingTarget, changeSceneProps, scene } = this.props.WPLayersStore
    const { snapshot } = snapshotStore
    // 是否有元素选中
    const isSelected = Boolean(editingTarget.id)
    // 是否禁用上一快照
    const disableSnapshotPrev = snapshot.currIndex <= 0
    // 是否禁用下一快照
    const disableSnapshotNext = snapshot.currIndex >= snapshot.total - 1

    const pageId = getLocalStorage('pageId') || this.state.pageId

    return (
      <div className={styles['header-inner']}>
        <div className={styles['left']}>
          {this.state.isModify ? (
            <ExitNotify
              name={scene.name}
              content={({ show }) => (
                <div onClick={show}>
                  <TuiaIcon type="icon-system_back" />
                  返回
                </div>
              )}
              confirm={this.saveAndGoBack}
            />
          ) : (
            <div onClick={this.goBack}>
              <TuiaIcon type="icon-system_back" />
              返回
            </div>
          )}
        </div>

        <div className={styles['middle']}>
          <div id="__page_operation_btns__" style={{ width: 192 }}>
            <div
              className={styles['item']}
              onClick={this.save.bind(this, false)}
            >
              <TuiaIcon type="menu_save" />
              <div>保存</div>
            </div>
            <div
              className={cn(styles['item'], {
                [styles['itemDisabled']]: disableSnapshotPrev
              })}
              onClick={() =>
                !disableSnapshotPrev && action(snapshotStore.changeSnapshot)(-1)
              }
            >
              <TuiaIcon type="menu_undo" />
              <div>撤销</div>
            </div>
            <div
              className={cn(styles['item'], {
                [styles['itemDisabled']]: disableSnapshotNext
              })}
              onClick={() =>
                !disableSnapshotNext && action(snapshotStore.changeSnapshot)(1)
              }
            >
              <TuiaIcon type="menu_redo" />
              <div>重做</div>
            </div>
            <div
              className={cn(styles['item'], {
                [styles['itemDisabled']]: !isSelected
              })}
              onClick={() => isSelected && this.handleDelete(this.props)}
            >
              <TuiaIcon type="menu_delete" />
              <div>删除</div>
            </div>
          </div>
          {/* <div className={styles['item']} style={{ width: 70 }}>
            <Dropdown
              overlay={
                <Menu>
                  <Menu.Item onClick={() => changeSceneProps({ dpr: 1 })}>1</Menu.Item>
                  <Menu.Item onClick={() => changeSceneProps({ dpr: 2 })}>2</Menu.Item>
                  <Menu.Item onClick={() => changeSceneProps({ dpr: 3 })}>3</Menu.Item>
                </Menu>
              }
              trigger={['click']}
            >
              <a className="ant-dropdown-link" href="#">
                Dpr: {this.props.WPLayersStore.scene.dpr} <Icon type="down" />
              </a>
            </Dropdown>
          </div> */}
        </div>
        <div className={styles['right']}>
          <Dropdown
            overlay={
              <Menu>
                <Menu.Item
                  onClick={() =>
                    changeSceneProps({ width: '320px' }) ||
                    hookStore.walkHooks('onSceneInnerWidthChangeEnd', {
                      width: 320
                    })
                  }
                >
                  iphone5/SE(320x568)
                </Menu.Item>
                <Menu.Item
                  onClick={() =>
                    changeSceneProps({ width: '375px' }) ||
                    hookStore.walkHooks('onSceneInnerWidthChangeEnd', {
                      width: 375
                    })
                  }
                >
                  iphone6/7/8(375x667)
                </Menu.Item>
              </Menu>
            }
            trigger={['click']}
          >
            <div className={styles['item']}>
              <TuiaIcon
                type="icon-menu_iphone"
                style={{ fontSize: 14, marginLeft: 4 }}
              />
              <div>机型</div>
            </div>
          </Dropdown>
          <PreviewH5
            id={pageId}
            title={scene.title}
            url={location.origin + `/preview?id=${pageId}&type=layer`}
            content={({ show }) => (
              <div
                id="___preview_btn___"
                className={cn(styles['item'], {
                  [styles['itemDisabled']]: !pageId
                })}
                onClick={() => {
                  if (pageId) {
                    show()
                  } else {
                    message.warning('请先保存')
                  }
                }}
              >
                <TuiaIcon type="icon-menu_preview" style={{ fontSize: 14 }} />
                <div>预览</div>
              </div>
            )}
          />
        </div>
      </div>
    )
  }
}
