import React, { Component } from 'react'
import styles from '../index.less'
import widgetsStyle from 'layersWp/widgets/widgets.less'
import { inject, observer } from 'mobx-react'
import { DropTarget } from 'react-dnd'
import * as types from 'layersWp/utils/itemType'
import Widgets from 'layersWp/widgets/allWidgets'
import { sceneUniqueId } from 'layersWp/config'
import { TriggerableGuide } from 'layersWp/features/guide'
import { WidgetContextGuider } from 'layersWp/guides'
import store from 'layersWp/store'

const typeArr = Object.keys(types).map(key => types[key])

const DropSpecEvents = {
  drop(props, monitor, component) {
    const DropContainerRect = document
      .getElementById(sceneUniqueId)
      .getBoundingClientRect()
    // 拖拽end时pointer坐标
    const pointerCoords = monitor.getClientOffset()
    const coordRelScene = {
      x: pointerCoords.x - DropContainerRect.x,
      y: pointerCoords.y - DropContainerRect.y
    }
    return {
      dropped: true,
      coordRelScene
    }
  },
  hover(props, monitor, component) {
    // console.log(props, monitor, component);
  },
  canDrop(props, monitor) {
    return true
  }
}

const collecting = (connect, monitor) => ({
  connectDropTarget: connect.dropTarget(),
  isOver: monitor.isOver(),
  canDrop: monitor.canDrop(),
  draggingColor: monitor.getItemType()
})

@inject('WPLayersStore')
@DropTarget(typeArr, DropSpecEvents, collecting)
@observer
export default class SceneInner extends Component {
  render() {
    const { connectDropTarget, style, WPLayersStore } = this.props
    const {
      backgroundMask,
      backgroundLight,
      closePosition
    } = WPLayersStore.scene
    const { skinType } = WPLayersStore
    return connectDropTarget(
      <div
        className={`${styles['scene-inner']} ${widgetsStyle['widgets-wrapper']}`}
        style={style}
        id={sceneUniqueId}
      >
        <div
          className={styles.mask}
          style={
            skinType === 51
              ? {
                  pointerEvents: 'none',
                  backgroundImage:
                    "url('//yun.dui88.com/20191202/A87666F9-6C0E-4EE5-AA94-06A0F5F39092.png')",
                  backgroundSize: 'contain',
                  backgroundColor: 'transparent'
                }
              : { pointerEvents: 'none' }
          }
        >
          {backgroundLight ? (
            <img
              src="//yun.tuisnake.com/h5-mami/couponPrize/light_190805.png"
              style={{ opacity: backgroundMask / 100 }}
            />
          ) : (
            ''
          )}
          <div
            className={styles.close}
            style={
              closePosition === 'bottom'
                ? {
                    top: 'auto',
                    right: 'auto',
                    bottom: 60,
                    left: '50%',
                    transform: 'translate(-50%)'
                  }
                : {}
            }
          />
        </div>

        {this.props.WPLayersStore.currentLayer.itemList.map((item, idx) => {
          const SpecWidget = Widgets[item.widgetType]
          return <SpecWidget key={idx} {...item} />
        })}
      </div>
    )
  }
}
