import React, { Component } from 'react'
import Inner from './inner'
import styles from '../index.less'
import { inject, observer } from 'mobx-react'
import { bodySizes, sceneUniqueId } from 'layersWp/config'
// import ResizerY from './resizerY'
import Addons from './addons'
import store from 'layersWp/store'

const minHeight = bodySizes.sceneContainer.inner.minHeight
const initWidth = bodySizes.sceneContainer.inner.initWidth
const initHeight = bodySizes.sceneContainer.inner.initHeight

@inject('WPLayersStore')
@observer
export default class Scene extends Component {
  constructor(props) {
    super(props)
    this.state = {
      stageHeight: initHeight,
      stageWidth: initWidth
    }
  }
  handleMouseMove(e) {
    e.preventDefault()
    typeof window.__widgetMouseMove__ === 'function' &&
      window.__widgetMouseMove__(e.clientX, e.clientY)
    typeof window.__widgetResizerMouseMove__ === 'function' &&
      window.__widgetResizerMouseMove__(e)
  }
  handleMouseUp = e => {
    if (typeof window.__widgetMouseUp__ === 'function') {
      window.__widgetMouseUp__(e.clientX, e.clientY)
    } else if (typeof window.__widgetResizerMouseMUp__ === 'function') {
      window.__widgetResizerMouseMUp__(e)
    } else {
      if (e.target.id === sceneUniqueId) {
        store.WPLayersStore.chooseTarget({ targetId: '' })
      }
    }
  }
  onResizingY = value => {
    this.setState({
      stageHeight: value
    })
  }
  componentDidMount = () => {}
  componentWillUnmount() {
    this.remove1 && this.remove1()
    this.remove2 && this.remove2()
    this.remove3 && this.remove3()
  }
  handleClick(e) {
    
    if (
      e.target.id === '__scene-container__' ||
      e.target.id === '___scene___id___'
    ) {
      store.WPLayersStore.chooseTarget({ targetId: '' })
    }
  }
  render() {
    const {
      title,
      backgroundImage,
      backgroundColor,
      backgroundRepeat,
      backgroundSize,
      backgroundPosition
    } = this.props.WPLayersStore.scene
    return (
      <div
        id="__scene-container__"
        className={styles['scene-container']}
        style={bodySizes.sceneContainer}
        onClick={this.handleClick}
        onMouseMoveCapture={this.handleMouseMove}
        onMouseUp={this.handleMouseUp}
      >
        {/* // TODO 后期可定义多个wrapper也就说同时编辑多页面 */}
        <div
          className={styles['wrapper']}
          style={{ width: this.state.stageWidth + 20 }}
        >
          <div className={styles['title']}>{title}</div>
          <Inner
            style={{
              width: this.state.stageWidth,
              minHeight: minHeight,
              height: this.state.stageHeight || 0,
              backgroundImage,
              backgroundColor,
              backgroundRepeat,
              backgroundSize,
              backgroundPosition
            }}
          />
          <div className={styles['addons']}>
            <Addons />
          </div>
          {/* <ResizerY
            stageWidth={this.state.stageWidth}
            onChanging={this.onResizingY}
          /> */}
        </div>
      </div>
    )
  }
}
