import React, { Component } from 'react'
import {
  Form,
  Input,
  Select,
  Tabs,
  Icon,
  Switch,
  InputNumber,
  Tooltip,
  message,
  Slider
} from 'antd'
import { action } from 'mobx'
import { inject, observer } from 'mobx-react'
import { PopupType } from 'layersWp/utils/itemType'
import store from 'layersWp/store'
import WXD from 'layersWp/constructors/editor/wxd'
import JumpEnum from 'layersWp/constructors/enum/jump'
import CodeEditor from './code'
import { jumpActionsMapping } from 'layersWp/utils/util'
import { getLocalStorage } from 'layersWp/utils/helper'
import AutoJump from './autoJump'
const { EDIT_TEMPLATE } = jumpActionsMapping
import { getTags } from 'layersWp/api'

const editorStyle = {
  position: 'relative',
  backgroundColor: '#fff',
  minHeight: '100%',
  overflow: 'auto',
  paddingBottom: 200
}

const FormItem = Form.Item
const Option = Select.Option
const TabPane = Tabs.TabPane

const FormItemProps = {
  labelCol: { span: 6 },
  wrapperCol: { span: 17 },
  colon: false,
  style: { width: '100%', fontSize: '12px !important' }
}

@inject('WPLayersStore')
@observer
export default class SceneEdit extends Component {
  handleChange = changed => {
    action(this.props.WPLayersStore.changeSceneProps)(changed)
  }
  handleLayerChange = changed => {
    action(this.props.WPLayersStore.changeLayerProps)(changed)
  }
  componentDidMount() {
    getTags().then(res => {
      this.setState({ tags: res.data })
    })
  }
  state = {
    tags: []
  }
  render() {
    const {
      scene,
      skinDesc,
      setDesc,
      currentLayer,
      skinTags,
      setSkinTags
    } = this.props.WPLayersStore
    const { tags } = this.state
    const isEditTemplate = getLocalStorage('jumpAction') === EDIT_TEMPLATE
    return (
      <div style={editorStyle}>
        <Tabs defaultActiveKey="1" style={{ height: '100%' }}>
          <TabPane tab="舞台" key="1">
            <Form layout="inline">
              <FormItem label="名称" {...FormItemProps}>
                <Input
                  value={scene.name}
                  maxLength={15}
                  onChange={e => this.handleChange({ name: e.target.value })}
                />
              </FormItem>
              {isEditTemplate && (
                <FormItem label="描述" {...FormItemProps}>
                  <Input
                    value={skinDesc}
                    onChange={e => setDesc(e.target.value)}
                  />
                </FormItem>
              )}

              <FormItem label="背景光" {...FormItemProps}>
                <Switch
                  checked={Boolean(scene.backgroundLight)}
                  onChange={value =>
                    this.handleChange({
                      backgroundLight: value ? 1 : 0
                    })
                  }
                />
              </FormItem>
              <FormItem label="标签" {...FormItemProps}>
                {/* 暂时单选 */}
                <Select
                  showSearch
                  filterOption={(input, option) =>
                    option.props.children.toLowerCase().indexOf(input.toLowerCase()) >= 0
                  }
                  value={skinTags[0]}
                  style={{ width: 104 }}
                  onChange={value => setSkinTags([value])}
                >
                  {tags.map((tag, index) => (
                    <Option value={tag.tagId} key={tag.tagId}>{tag.tagName}</Option>
                  ))}
                </Select>
              </FormItem>
              <FormItem label="不透明度" {...FormItemProps}>
                <Slider
                  value={scene.backgroundMask}
                  onChange={value =>
                    this.handleChange({ backgroundMask: value })
                  }
                />
              </FormItem>

              <FormItem label="关闭按钮" {...FormItemProps}>
                <Select
                  value={scene.closePosition}
                  style={{ width: 104 }}
                  onChange={value =>
                    this.handleChange({ closePosition: value })
                  }
                >
                  <Option value="rightTop">右上角</Option>
                  <Option value="bottom">底部</Option>
                </Select>
              </FormItem>
            </Form>
            <Form>
              <FormItem label={<CodeEditor />} {...FormItemProps} />
            </Form>
          </TabPane>
          <TabPane tab="场景" key="2">
            <Form layout="inline">
              <FormItem label="名称" {...FormItemProps}>
                <Input
                  value={currentLayer.name}
                  maxLength={15}
                  onChange={e =>
                    this.handleLayerChange({ name: e.target.value })
                  }
                />
              </FormItem>
              <AutoJump
                handleChange={this.handleLayerChange}
                {...currentLayer.autoJump}
              ></AutoJump>
            </Form>
          </TabPane>
        </Tabs>
      </div>
    )
  }
}
