import React, { Component } from 'react'
import { Modal, Tree } from 'antd'
import CodeMirror from 'react-codemirror'
import 'codemirror/lib/codemirror.css'
import { inject, observer } from 'mobx-react'
import store from 'layersWp/store'
import styles from './code.less'

const { TreeNode } = Tree
@observer
export default class extends Component {
  state = {
    modalVisible: false
  }
  render() {
    const layersStore = store.WPLayersStore
    const { code } = layersStore.scene
    return (
      <div>
        <a
          href="javascript:;"
          onClick={() => this.setState({ modalVisible: true })}
        >
          自定义代码
        </a>
        <Modal
          title={null}
          footer={null}
          width="80%"
          visible={this.state.modalVisible}
          bodyStyle={{ padding: 0 }}
          onCancel={() => this.setState({ modalVisible: false })}
        >
          <div className={styles['code-wrap']}>
            <CodeMirror
              value={code}
              onChange={newCode => {
                layersStore.changeSceneProps({
                  code: newCode
                })
              }}
              options={{
                mode: 'javascript',
                lineNumbers: true
              }}
              className={styles['code-editor']}
            />
            <Tree blockNode defaultExpandAll className={styles['tree-wrap']}>
              {layersStore.layerList.map(layer => (
                <TreeNode
                  key={layer.layerId}
                  title={`${layer.layerId}(${layer.name})`}
                >
                  {layer.itemList.map(item => (
                    <TreeNode
                      key={item.targetId}
                      title={`${item.targetId}(${item[item.widgetType].name})`}
                    />
                  ))}
                </TreeNode>
              ))}
            </Tree>
          </div>
        </Modal>
      </div>
    )
  }
}
