import React from 'react'
import { Form, Switch, InputNumber, Select } from 'antd'

const FormItem = Form.Item
const Option = Select.Option
const FormItemProps = {
  labelCol: { span: 6 },
  wrapperCol: { span: 17 },
  colon: false,
  style: { width: '100%', fontSize: '12px !important' }
}
export default function AutoJump({ enable, delay, type, handleChange }) {
  return (
    <React.Fragment>
      <FormItem label="自动跳转" {...FormItemProps}>
        <Switch
          checked={Boolean(enable)}
          onChange={value => handleChange({ 'autoJump.enable': value ? 1 : 0 })}
        />
      </FormItem>
      <FormItem label="延迟(s)" {...FormItemProps}>
        <InputNumber
          value={delay}
          min={0}
          style={{ width: '48px' }}
          onChange={value => handleChange({ 'autoJump.delay': value })}
        />
      </FormItem>
      <FormItem label="跳转方式" {...FormItemProps}>
        <Select
          value={type}
          style={{ width: 100 }}
          onChange={value => handleChange({ 'autoJump.type': value })}
        >
          <Option value="link">跳转链接</Option>
        </Select>
      </FormItem>
    </React.Fragment>
  )
}
