import React, { Component } from 'react'
import styles from './layer.less'
import store from 'layersWp/store'
import { Popover, Icon, message } from 'antd'
import { action } from 'mobx'
import { observer, inject } from 'mobx-react'
import { PopupType } from 'layersWp/utils/itemType'
import TuiaIcon from 'layersWp/constructors/fc/icon'

@inject('WPLayersStore')
@observer
export default class AddonLayerMng extends Component {
  state = {}
  handleChange = (layerId, obj) => {
    action(store.WPLayersStore.changeLayerPropsById)(layerId, obj)
  }
  chooseLayer = layerId => {
    action(store.WPLayersStore.chooseLayer)({ layerId })
  }
  render() {
    // 过滤弹层
    const layers = store.WPLayersStore.layerList
    const editingLayerId = store.WPLayersStore.editingLayer.id

    return (
      <div className={styles['layerAddon']}>
        <Popover
          overlayClassName="__popover_overlay__"
          placement="rightBottom"
          title={
            <div className={styles['popup-title']}>
              <Icon type="eye" />
              <Icon
                type="delete"
                onClick={() => {
                  action(store.WPLayersStore.removeLayerById)(
                    editingLayerId
                  ) === 0
                    ? message.warn('主场景不可删除')
                    : ''
                }}
                style={
                  editingLayerId
                    ? {}
                    : {
                        color: '#999',
                        cursor: 'not-allowed'
                      }
                }
              />
            </div>
          }
          content={
            <div>
              {layers.map((item, index) => {
                const { name, style } = item
                const { display } = style
                const isShow = display !== 'none'
                const isThisLayer = editingLayerId === item.layerId
                return (
                  <div
                    key={index}
                    className={
                      styles['popup-item'] +
                      ' ' +
                      (isThisLayer ? styles['popup-selected'] : '')
                    }
                    onClick={() => {
                      if (editingLayerId === item.layerId) {
                        this.chooseLayer('')
                      } else {
                        this.chooseLayer(item.layerId)
                      }
                    }}
                  >
                    {/* <TuiaIcon
                      type={isShow ? 'system_eye' : 'system_eye-hide1'}
                      onClick={e => {
                        this.handleChange(item.layerId, {
                          'style.display': isShow ? 'none' : 'block'
                        })
                        e.stopPropagation()
                      }}
                      style={{ color: isThisLayer && '#fff' }}
                    /> */}
                    {name}
                  </div>
                )
              })}
            </div>
          }
          trigger="hover"
        >
          <div className={styles['deactived']}>
            <Icon type="switcher" className={styles['iconStyle']} />
            <div style={{ marginTop: '5px' }}>场景</div>
          </div>
        </Popover>
      </div>
    )
  }
}
