import React, { Component } from 'react'
import styles from './layer.less'
import store from 'layersWp/store'
import { Popover, Icon } from 'antd'
import { observer, inject } from 'mobx-react'

@inject('WPLayersStore')
@observer
export default class AddonLayerAdd extends Component {
  handleAdd = () => {
    store.WPLayersStore.addLayer()
  }
  render() {
    return (
      <div className={styles['layerAddon']}>
        <Popover
          placement="rightBottom"
          content="添加一个新场景"
          trigger="hover"
        >
          <div className={styles['deactived']} onClick={this.handleAdd}>
            <Icon type="plus" style={{ fontSize: 26 }} />
          </div>
        </Popover>
      </div>
    )
  }
}
