import React, { Component } from 'react'
import styles from './layer.less'
import store from 'layersWp/store'
import { Popover, Icon } from 'antd'
import { action } from 'mobx'
import { observer, inject } from 'mobx-react'
import { PopupType } from 'layersWp/utils/itemType'
import TuiaIcon from 'layersWp/constructors/fc/icon'
import { LayerGuider } from 'layersWp/guides'

@inject('WPLayersStore')
@observer
export default class AddonLayer extends Component {
  state = {}
  handleChange = (targetId, obj) => {
    action(store.WPLayersStore.changeItemPropsById)(targetId, obj)
  }
  chooseTarget = targetId => {
    action(store.WPLayersStore.chooseTarget)({ targetId })
  }
  render() {
    // 过滤弹层
    const items = store.WPLayersStore.currentLayer.itemList
    const hasItem = items.length > 0
    // console.log(store.WPLayersStore.editingLayer.id)
    const editingTargetId = store.WPLayersStore.editingTarget.id

    return (
      <div className={styles['layerAddon']} id="__layer_addon__">
        {hasItem && (
          <Popover
            overlayClassName="__popover_overlay__"
            placement="rightBottom"
            title={
              <div className={styles['popup-title']}>
                <Icon type="eye" />
                <Icon
                  type="delete"
                  onClick={() => {
                    editingTargetId &&
                      action(store.WPLayersStore.removeItemById)(
                        editingTargetId
                      )
                  }}
                  style={
                    editingTargetId
                      ? {}
                      : {
                        color: '#999',
                        cursor: 'not-allowed'
                      }
                  }
                />
              </div>
            }
            content={
              <div>
                {items.map((item, index) => {
                  const { name, style } = item[item.widgetType]
                  const { display } = style
                  const isShow = display !== 'none'
                  const isThisWidget = editingTargetId === item.targetId
                  return (
                    <div
                      key={index}
                      className={
                        styles['popup-item'] +
                        ' ' +
                        (isThisWidget ? styles['popup-selected'] : '')
                      }
                      onClick={() => {
                        if (editingTargetId === item.targetId) {
                          this.chooseTarget('')
                        } else {
                          this.chooseTarget(item.targetId)
                        }
                      }}
                    >
                      <TuiaIcon
                        type={isShow ? 'system_eye' : 'system_eye-hide1'}
                        onClick={e => {
                          this.handleChange(item.targetId, {
                            'style.display': isShow ? 'none' : 'block'
                          })
                          e.stopPropagation()
                        }}
                        style={{ color: isThisWidget && '#fff' }}
                      />
                      {name}
                    </div>
                  )
                })}
              </div>
            }
            trigger="hover"
          >
            <div className={styles['deactived']}>
              <TuiaIcon
                type="icon-control_layer"
                className={styles['iconStyle']}
              />
              <div style={{ marginTop: '5px' }}>图层</div>
            </div>
          </Popover>
        )}
      </div>
    )
  }
}
