import React, { Component } from 'react'
import SceneEdit from 'layersWp/parts/body/scene/editor'
import Editors from 'layersWp/widgets/allEditors'
import { inject, observer } from 'mobx-react'
import styles from './index.less'
import { tran2arr } from 'layersWp/utils/helper'
import store from 'layersWp/store'
@inject('WPLayersStore')
@observer
export default class AsideRight extends Component {
  componentDidMount = () => {
    document
      .querySelector(`.${styles['editor-wrapper']}`)
      .addEventListener('mousewheel', function(e) {
        this.scrollTop += e.deltaY
      })
  }
  render() {
    const {
      layerList,
      editingTarget,
      editingLayer,
      currentLayer
    } = this.props.WPLayersStore
    const currTargetId = editingTarget.id
    let targetLayer = currentLayer
    const list = targetLayer.itemList || []
    const targetInfo = list.find(v => v.targetId === currTargetId)
    let com = <SceneEdit />
    if (targetInfo) {
      const Editor = Editors[targetInfo.widgetType]
      com = <Editor {...targetInfo} />
    }
    return <div className={styles['editor-wrapper']}>{com}</div>
  }
}
