import React, { Component } from 'react'
import ItemsStyle from 'layersWp/widgets/items.less'
import Items from 'layersWp/widgets/allItems'
import classify from './classify'
import { observer } from 'mobx-react'
@observer
export default class ItemsTab extends Component {
  render() {
    return (
      <React.Fragment>
        {classify.map((item, index) => {
          return (
            <div key={index}>
              <div className={ItemsStyle.title}>{item.title}</div>
              <div className={ItemsStyle.items}>
                {Object.keys(Items)
                  .filter(type => item.types.indexOf(type) !== -1)
                  .map((key, idx) => {
                    const ItemCom = Items[key]
                    return <ItemCom key={idx} />
                  })}
              </div>
            </div>
          )
        })}
      </React.Fragment>
    )
  }
}
