import React from 'react'
import styles from './holy-grail.less'
import AsideLeft from 'layersWp/parts/aside/left/index'
import AsideRight from 'layersWp/parts/aside/right/index'
import Header from 'layersWp/parts/header'
import Body from 'layersWp/parts/body'
import { generateDragDropContext } from '../utils/drag'
import { observer } from 'mobx-react'

@observer
export default class HolyGrail extends React.Component {
  render() {
    const DragDropContainer = generateDragDropContext()
    return (
      <DragDropContainer>
        <div className={styles['work-place-container']}>
          <div className={styles.header} id="__aside_top__">
            <Header />
          </div>
          <div className={styles.body} id="__body__">
            <Body />
          </div>
          <aside className={styles['aside-left']} id="__aside_left__">
            <AsideLeft />
          </aside>
          <aside className={styles['aside-right']} id="__aside_right__">
            <AsideRight />
          </aside>
        </div>
      </DragDropContainer>
    )
  }
}
