import React, { Component } from 'react'
import { inject } from 'mobx-react'
import { hot } from 'react-hot-loader'
import resetStore from 'layersWp/features/reset-store'
import clearSnapshot from 'layersWp/features/clear-snapshot'
import { SteppableGuide } from 'layersWp/features/guide'
import Layout from './layout/holy-grail'
import keyListen from 'layersWp/features/key-listen'
import Loading from 'layersWp/features/loading'

import * as types from 'layersWp/utils/itemType'
import store from 'layersWp/store'
import hookStore from 'layersWp/store/hook'
import {
  removeLocalStorage,
  getLocalStorage,
  getNumber,
  versionInvalid
} from 'layersWp/utils/helper'
import { getJson, getTemplateJson } from './api'
import { version } from 'layers/version.json'
import { notification, Icon } from 'antd'
import { jumpActionsMapping } from 'layersWp/utils/util'
const { WPLayersStore } = store

const getPageJson = (isTemplate, params) => {
  if (isTemplate) {
    return getTemplateJson(...params)
  } else {
    return getJson(...params)
  }
}
@inject('WPLayersStore')
class Workplace extends Component {
  constructor() {
    super(...arguments)
    this.ref = React.createRef()
  }
  init() {
    // 通过new-page组件传来的初始化数据渲染工作台
    let createScene = getLocalStorage('createScene')
    if (createScene) {
      store.WPHookStore.walkHooks('onSceneInnerWidthChangeEnd', {
        width: getNumber(createScene.width)
      })
      store.WPLayersStore.init(createScene)
      removeLocalStorage('createScene')
    }
    const { COPY_LAYER, USE_TEMPLATE, EDIT_TEMPLATE } = jumpActionsMapping
    // 通过复制或编辑的入口进入，需要加载远程数据
    const pageId = getLocalStorage('pageId')
    const jumpAction = getLocalStorage('jumpAction')
    const isCopy = jumpAction === COPY_LAYER
    const isTemplate =
      jumpAction === USE_TEMPLATE || jumpAction === EDIT_TEMPLATE
    if (!pageId) return
    Loading.show()

    getPageJson(isTemplate, [pageId]).then(res => {
      try {
        if (res.code === 0) {
          if (res.data) {
            let pageJson = {}
            try {
              pageJson = JSON.parse(res.data.pageJson)
            } catch (err) {
              pageJson = res.data.pageJson
            }
            // 编辑或复制逻辑
            let { page, layers } = pageJson
            // 版本号提示
            const pageVersion = pageJson.version || '0'
            if (versionInvalid(version, pageVersion)) {
              this.versionNotification()
            }

            // 组装适用于管理端的数据结构
            const layerList = layers.map(layer => {
              let layerBee = {
                ...layer,
                style: {
                  display: 'none'
                },
                itemList: layer.elements.map(item => {
                  if (item.type === types.PopupType) {
                    return {
                      widgetType: item.type,
                      targetId: item.id,
                      [item.type]: {
                        ...item,
                        elements:
                          item.elements &&
                          item.elements.map(el => {
                            return {
                              widgetType: el.type,
                              targetId: el.id,
                              [el.type]: {
                                ...el,
                                // 使用原始定位信息回显
                                style: el.originalStyle
                              }
                            }
                          })
                      }
                    }
                  }
                  return {
                    widgetType: item.type,
                    targetId: item.id,
                    [item.type]: item
                  }
                })
              }
              delete layerBee.elements
              return layerBee
            })
            if (isCopy) {
              removeLocalStorage('pageId')
              page.name += '-复制'
            }
            // 模版编辑
            if (res.data.skinDesc) {
              WPLayersStore.setDesc(res.data.skinDesc)
            }
            // 标签
            if (res.data.skinTags) {
              WPLayersStore.setSkinTags(res.data.skinTags)
            }
            WPLayersStore.init(page, layerList)
            // onInit钩子调用
            hookStore.walkHooks('onInit', { page })
          } else {
            // 新建页面逻辑
          }
          removeLocalStorage('isCopy')
        } else {
          // 请求接口失败逻辑
        }
      } catch (e) {
        console.log(e)
      }
      Loading.cancel()
    })
  }
  componentDidMount() {
    // cacheNotify()
    // 关闭浏览器tab前保存副本
    // cachePageOnUnload()
    // 应用本地缓存
    // applyCachedPage()
    // 重置store
    resetStore()
    // 清除快照（必须在重置store之后执行）
    clearSnapshot()
    // 键盘事件监听
    this.keydownListenRemover = keyListen()
    // 新手引导
    // this.timer = setTimeout(() => {
    //   this.ref.current.setup({
    //     guides: [
    //       {
    //         id: 'guide1',
    //         mode: 'step',
    //         theme: 'emphasized',
    //         steps: [
    //           {
    //             src: '//yun.tuia.cn/tuia/jimo-web-pro/navigator1.gif',
    //             text: <Step1 />,
    //             placement: 'right',
    //             domSelector: '#__aside_left__',
    //             introOffset: {
    //               top: 30,
    //               left: 18
    //             },
    //             arrowOffset: {
    //               top: 100
    //             }
    //           },
    //           {
    //             src: '//yun.tuia.cn/tuia/jimo-web-pro/navigator2.gif',
    //             text: <Step2 />,
    //             placement: 'left',
    //             domSelector: '#__aside_right__',
    //             introOffset: {
    //               top: 30,
    //               right: 18
    //             },
    //             arrowOffset: {
    //               top: 100
    //             }
    //           },
    //           {
    //             src: '//yun.tuia.cn/tuia/jimo-web-pro/navigator3.gif',
    //             text: <Step3 />,
    //             placement: 'bottom',
    //             domSelector: '#__page_operation_btns__',
    //             introOffset: {
    //               top: 20,
    //               left: -140
    //             }
    //           },
    //           {
    //             src: '//yun.tuia.cn/tuia/jimo-web-pro/navigator4.gif',
    //             text: <Step4 />,
    //             placement: 'bottom',
    //             domSelector: '#___preview_btn___',
    //             introOffset: {
    //               top: 20,
    //               left: -360
    //             }
    //           }
    //         ]
    //       }
    //     ]
    //   })
    //   clearTimeout(this.timer)
    // }, 2000)
    this.init()
  }
  componentWillUnmount() {
    this.keydownListenRemover && this.keydownListenRemover()
    clearTimeout(this.timer)
  }
  versionNotification = () => {
    notification.open({
      message: '版本已过旧',
      description:
        '当前页面版本已过旧，将无法使用部分最新功能，建议重新创建新页面！如重新编辑，为避免出现页面问题，请重新预览后再发布！！！',
      icon: <Icon type="warning" style={{ color: 'red' }} />,
      duration: 10
    })
  }
  render() {
    return (
      <div id="__pro_workplace__" onContextMenu={e => e.preventDefault()}>
        <Layout />
        <SteppableGuide ref={this.ref} />
      </div>
    )
  }
}
export default hot(module)(Workplace)
