import { staticResourcePrefix } from 'layersWp/config'
import React from 'react'

export function PopupGuider({ cancel }) {
  const arr = [
    {
      src: `${staticResourcePrefix}/guide-click@2x.png`,
      title: '鼠标单击',
      help: '显示/收起弹层模式'
    },
    {
      src: `${staticResourcePrefix}/guide-hover@2x.png`,
      title: '鼠标移入',
      help: '展开弹层列表，查看/删除弹层'
    }
  ]
  return (
    <div style={{ height: 264, width: 320, padding: '16px 20px' }}>
      {arr.map((item, index) => {
        return (
          <div key={index} style={{ display: 'flex', marginBottom: 40 }}>
            <img src={item.src} style={{ width: 80, height: 64 }} />
            <div style={{ marginLeft: 16 }}>
              <div style={{ color: '#333', fontSize: 16, marginBottom: 24 }}>
                {item.title}
              </div>
              <div style={{ color: '#999', fontSize: 14 }}>{item.help}</div>
            </div>
          </div>
        )
      })}
      <div
        style={{
          color: '#2D9AFF',
          fontSize: 14,
          cursor: 'pointer',
          position: 'absolute',
          bottom: 24,
          right: 24
        }}
        onClick={cancel}
      >
        我知道了
      </div>
    </div>
  )
}

export function LayerGuider({ cancel }) {
  return (
    <div style={{ height: 100, width: 250, padding: '16px 24px' }}>
      <div
        style={{
          color: '#333',
          fontSize: 16,
          marginBottom: 20,
          lineHeight: '24px'
        }}
      >
        图层列表
      </div>
      <div style={{ display: 'flex', justifyContent: 'space-between' }}>
        <div style={{ color: '#999', fontSize: 14 }}>查看/隐藏/删除图层</div>
        <div
          style={{ color: '#2D9AFF', fontSize: 14, cursor: 'pointer' }}
          onClick={cancel}
        >
          好的
        </div>
      </div>
    </div>
  )
}

export function UploadErrorGuider({ cancel }) {
  return (
    <div
      style={{
        position: 'relative',
        padding: '16px 20px',
        width: 300,
        height: 159
      }}
    >
      <div
        style={{
          color: '#333',
          fontSize: 16,
          lineHeight: '32px',
          marginBottom: 16
        }}
      >
        您上传的图片不是标准尺寸
      </div>
      <div style={{ color: '#999', fontSize: 12, lineHeight: '20px' }}>
        尺寸过大或过小可能会造成视觉体验差，建议重新上传标准尺寸的图片。
      </div>
      <div
        style={{
          color: '#2D9AFF',
          fontSize: 14,
          lineHeight: '24px',
          position: 'absolute',
          bottom: 16,
          right: 24,
          cursor: 'pointer'
        }}
        onClick={cancel}
      >
        我知道了
      </div>
    </div>
  )
}

export function WidgetContextGuider({ cancel }) {
  return (
    <div
      style={{
        position: 'relative',
        padding: '16px 20px',
        width: 325,
        height: 234,
        display: 'flex'
      }}
    >
      <img
        src={`${staticResourcePrefix}/widget-context@2x.png`}
        style={{ width: 116, marginRight: 16 }}
      />
      <div style={{ flex: 1 }}>
        <div
          style={{
            color: '#333',
            fontSize: 16,
            lineHeight: '24px',
            marginBottom: 16
          }}
        >
          试试鼠标右键吧
        </div>
        <div style={{ color: '#999', fontSize: 14, lineHeight: '16px' }}>
          选中组件，右键
        </div>
        <div
          style={{
            marginLeft: 16,
            marginTop: 8,
            lineHeight: '20px',
            fontSize: 12,
            color: '#999'
          }}
        >
          <ul style={{ listStyle: 'unset' }}>
            <li style={{ listStyle: 'unset' }}>复制</li>
            <li style={{ listStyle: 'unset' }}>删除</li>
            <li style={{ listStyle: 'unset' }}>上移一层</li>
            <li style={{ listStyle: 'unset' }}>下移一层</li>
          </ul>
        </div>
      </div>
      <div
        style={{
          color: '#2D9AFF',
          fontSize: 14,
          lineHeight: '24px',
          position: 'absolute',
          bottom: 16,
          right: 24,
          cursor: 'pointer'
        }}
        onClick={cancel}
      >
        好的
      </div>
    </div>
  )
}

export function Step1() {
  return (
    <div>
      <div
        style={{
          color: '#333',
          fontSize: 16,
          lineHeight: '24px',
          marginBottom: 8
        }}
      >
        组件库
      </div>
      <div
        style={{
          color: '#999',
          fontSize: 12,
          lineHeight: '24px',
          marginBottom: 24
        }}
      >
        所有的组件都在这里
      </div>
      <div
        style={{
          color: '#333',
          fontSize: 16,
          lineHeight: '24px',
          marginBottom: 8
        }}
      >
        创建组件
      </div>
      <div style={{ color: '#999', fontSize: 12, lineHeight: '24px' }}>
        按住鼠标左键，拖拽到舞台区域
      </div>
    </div>
  )
}

export function Step2() {
  return (
    <div>
      <div
        style={{
          color: '#333',
          fontSize: 16,
          lineHeight: '24px',
          marginBottom: 8
        }}
      >
        舞台
      </div>
      <div
        style={{
          color: '#999',
          fontSize: 12,
          lineHeight: '24px',
          marginBottom: 24
        }}
      >
        编辑落地页信息
      </div>
      <div
        style={{
          color: '#333',
          fontSize: 16,
          lineHeight: '24px',
          marginBottom: 8
        }}
      >
        组件属性栏
      </div>
      <div style={{ color: '#999', fontSize: 12, lineHeight: '24px' }}>
        编辑组件属性
      </div>
    </div>
  )
}

export function Step3() {
  return (
    <div>
      <div
        style={{
          color: '#333',
          fontSize: 16,
          lineHeight: '24px',
          marginBottom: 16
        }}
      >
        页面操作按钮
      </div>
      <ul
        style={{
          marginLeft: 16,
          marginTop: 8,
          lineHeight: '32px',
          fontSize: 14,
          listStyle: 'unset',
          color: '#999'
        }}
      >
        <li style={{ listStyle: 'unset' }}>保存页面</li>
        <li style={{ listStyle: 'unset' }}>撤销一步</li>
        <li style={{ listStyle: 'unset' }}>重做一步</li>
        <li style={{ listStyle: 'unset' }}>删除组件</li>
      </ul>
    </div>
  )
}

export function Step4() {
  return (
    <div>
      <div
        style={{
          color: '#333',
          fontSize: 16,
          lineHeight: '24px',
          marginBottom: 16
        }}
      >
        预览页面
      </div>
      <div style={{ color: '#999', fontSize: 12, lineHeight: '24px' }}>
        通过预览查看上线效果
      </div>
    </div>
  )
}
