import React from 'react'
import ReactDOM from 'react-dom'
import { staticResourcePrefix } from 'layersWp/config'

export default class Loading {
  static id = '__wp_loading__'
  static show () {
    if (document.getElementById(Loading.id)) return false
    const container = document.createElement('div')
    container.id = Loading.id
    document.body.appendChild(container)
    const loadingContainerStyle = {
      position: 'absolute',
      top: 0,
      bottom: 0,
      left: 0,
      right: 0,
      zIndex: 10000,
      display: 'flex',
      justifyContent: 'center',
      alignItems: 'center',
      backgroundColor: 'rgba(255,255,255,.8)',
      transition: 'all .2s ease-in-out',
      opacity: 0
    }
    ReactDOM.render(
      <div style={loadingContainerStyle} onClick={Loading.cancel}>
        <img style={{ width: 100, height: 100 }} src={`${staticResourcePrefix}/jimu_loading_new.gif`} />
      </div>,
      container
    )
    Promise.resolve().then(() => {
      document.querySelector(`#${Loading.id}>div`).style.opacity = 1
    })
  }
  static cancel () {
    const container = document.getElementById(Loading.id)
    const inner = document.querySelector(`#${Loading.id}> div`)
    inner.style.opacity = 0
    const timer = setTimeout(() => {
      container.remove()
      clearTimeout(timer)
    }, 200)
  }
}
