import store from 'layersWp/store'

export default function handleKeyPress() {
  let keyupHandler = (e) => {
    store.WPHookStore.walkHooks('onSceneKeyup', { e })
  }
  let keydownHandler = (e) => {
    store.WPHookStore.walkHooks('onSceneKeydown', { e })
  }
  document.addEventListener('keyup', keyupHandler)
  document.addEventListener('keydown', keydownHandler)
  return () => {
    document.removeEventListener('keyup', keyupHandler)
    document.removeEventListener('keydown', keydownHandler)
  }
}
