import React, { Component } from 'react'
import styles from './index.less'
import { inject, observer } from 'mobx-react'
import { stopPropagation, getNumber, getDeg } from 'layersWp/utils/helper'
import { sceneUniqueId } from 'layersWp/config'

@inject('WPLayersStore')
@observer
export default class Outter extends Component {
  state = {
    mouseInitPos: {
      x: NaN,
      y: NaN
    },
    type: '',
    initTarget: {}
  };
  calc = (type, e) => {
    if (type === 'lt') {
      const offsetX = e.clientX - this.state.mouseInitPos.x
      const offsetY = e.clientY - this.state.mouseInitPos.y
      const width = getNumber(this.state.initTarget.width) + -offsetX
      const height = getNumber(this.state.initTarget.height) + -offsetY
      const left = getNumber(this.state.initTarget.left) + offsetX
      const top = getNumber(this.state.initTarget.top) + offsetY
      const deg = getNumber(this.state.initTarget.transform)
      return {
        width,
        height,
        left,
        top,
        deg
      }
    } else if (type === 'ro') {
      const { left, top, width, height } = this.state.initTarget
      const sceneInnerRect = document.getElementById(sceneUniqueId).getBoundingClientRect()
      const deg = getDeg(sceneInnerRect.left + getNumber(left) + getNumber(width) / 2, sceneInnerRect.top + getNumber(top) + getNumber(height) / 2, e.clientX, e.clientY)
      return {
        left: getNumber(left),
        top: getNumber(top),
        width: getNumber(width),
        height: getNumber(height),
        deg
      }
    } else if (type === 'ct') {
      const { left, top, width, height, transform } = this.state.initTarget
      const offsetY = e.clientY - this.state.mouseInitPos.y
      return {
        width: getNumber(width),
        height: getNumber(height) + -offsetY,
        left: getNumber(left),
        top: getNumber(top) + offsetY,
        deg: getNumber(transform)
      }
    } else if (type === 'cb') {
      const { left, top, width, height, transform } = this.state.initTarget
      const offsetY = e.clientY - this.state.mouseInitPos.y
      return {
        width: getNumber(width),
        height: getNumber(height) + offsetY,
        left: getNumber(left),
        top: getNumber(top),
        deg: getNumber(transform)
      }
    } else if (type === 'lm') {
      const { left, top, width, height, transform } = this.state.initTarget
      const offsetX = e.clientX - this.state.mouseInitPos.x
      return {
        width: getNumber(width) + -offsetX,
        height: getNumber(height),
        left: getNumber(left) + offsetX,
        top: getNumber(top),
        deg: getNumber(transform)
      }
    } else if (type === 'rm') {
      const { left, top, width, height, transform } = this.state.initTarget
      const offsetX = e.clientX - this.state.mouseInitPos.x
      return {
        width: getNumber(width) + offsetX,
        height: getNumber(height),
        left: getNumber(left),
        top: getNumber(top),
        deg: getNumber(transform)
      }
    } else if (type === 'rt') {
      const offsetX = e.clientX - this.state.mouseInitPos.x
      const offsetY = e.clientY - this.state.mouseInitPos.y
      const width = getNumber(this.state.initTarget.width) + offsetX
      const height = getNumber(this.state.initTarget.height) + -offsetY
      const left = getNumber(this.state.initTarget.left)
      const top = getNumber(this.state.initTarget.top) + offsetY
      const deg = getNumber(this.state.initTarget.transform)
      return {
        width,
        height,
        left,
        top,
        deg
      }
    } else if (type === 'rb') {
      const offsetX = e.clientX - this.state.mouseInitPos.x
      const offsetY = e.clientY - this.state.mouseInitPos.y
      const width = getNumber(this.state.initTarget.width) + offsetX
      const height = getNumber(this.state.initTarget.height) + offsetY
      const left = getNumber(this.state.initTarget.left)
      const top = getNumber(this.state.initTarget.top)
      const deg = getNumber(this.state.initTarget.transform)
      return {
        width,
        height,
        left,
        top,
        deg
      }
    } else if (type === 'lb') {
      const offsetX = e.clientX - this.state.mouseInitPos.x
      const offsetY = e.clientY - this.state.mouseInitPos.y
      const width = getNumber(this.state.initTarget.width) + -offsetX
      const height = getNumber(this.state.initTarget.height) + offsetY
      const left = getNumber(this.state.initTarget.left) + offsetX
      const top = getNumber(this.state.initTarget.top)
      const deg = getNumber(this.state.initTarget.transform)
      return {
        width,
        height,
        left,
        top,
        deg
      }
    }
  };
  handleMouseDown = (type, e) => {
    e.persist()
    stopPropagation(e)
    this.setState({
      mouseInitPos: {
        x: e.clientX,
        y: e.clientY
      },
      type,
      initTarget: { ...this.props.targetStyle }
    })
    window.__widgetResizerMouseMove__ = this.__handleMouseMove__
    window.__widgetResizerMouseMUp__ = this.__handleMouseUp__
  };
  __handleMouseMove__ = e => {
    stopPropagation(e)
    const result = this.calc(this.state.type, e)
    this.props.onReszie(result)
  };
  __handleMouseUp__ = e => {
    stopPropagation(e)
    const result = this.calc(this.state.type, e)
    this.props.onReszieComplete(result)
    this.setState({
      initTarget: result
    })
    window.__widgetResizerMouseMove__ = null
    window.__widgetResizerMouseMUp__ = null
  };
  render () {
    let { options } = this.props
    options || (options = {})
    const { lt, rt, ct, ro, rm, rb, lb, cb, lm } = options
    return (
      <React.Fragment>
        <div className={styles['resizerTop']}>
          <div className={styles['lt']} {...generateProps(lt)} />
          <div className={styles['rt']} {...generateProps(rt)} />
          <div className={styles['ct']} {...generateProps(ct)} />
          <div className={styles['ro']} {...generateProps(ro)} />
          <div className={styles['lt-handler']} {...generateProps(lt)} onMouseDown={e => controlBehavior(e, lt) && this.handleMouseDown('lt', e)} />
          <div className={styles['rt-handler']} {...generateProps(rt)} onMouseDown={e => controlBehavior(e, rt) && this.handleMouseDown('rt', e)} />
          <div className={styles['ct-handler']} {...generateProps(ct)} onMouseDown={e => controlBehavior(e, ct) && this.handleMouseDown('ct', e)} />
          <div className={styles['ro-handler']} {...generateProps(ro)} onMouseDown={e => controlBehavior(e, ro) && this.handleMouseDown('ro', e)} />
        </div>
        <div className={styles['resizerRight']}>
          <div className={styles['rm']} {...generateProps(rm)} />
          <div className={styles['rm-handler']} {...generateProps(rm)} onMouseDown={e => controlBehavior(e, rm) && this.handleMouseDown('rm', e)} />
        </div>
        <div className={styles['resizerBottom']}>
          <div className={styles['rb']} {...generateProps(rb)} />
          <div className={styles['lb']} {...generateProps(lb)} />
          <div className={styles['cb']} {...generateProps(cb)} />
          <div className={styles['rb-handler']} {...generateProps(rb)} onMouseDown={e => controlBehavior(e, rb) && this.handleMouseDown('rb', e)} />
          <div className={styles['lb-handler']} {...generateProps(lb)} onMouseDown={e => controlBehavior(e, lb) && this.handleMouseDown('lb', e)} />
          <div className={styles['cb-handler']} {...generateProps(cb)} onMouseDown={e => controlBehavior(e, cb) && this.handleMouseDown('cb', e)} />
        </div>
        <div className={styles['resizerLeft']}>
          <div className={styles['lm']} {...generateProps(lm)} />

          <div className={styles['lm-handler']} {...generateProps(lm)} onMouseDown={e => controlBehavior(e, lm) && this.handleMouseDown('lm', e)} />
        </div>
      </React.Fragment>
    )
  }
}

// visible disabled hidden
function generateProps (type = 'visible') {
  if (type === 'hidden') {
    return {
      style: {
        display: 'none'
      }
    }
  } else if (type === 'disabled') {
    return {
      style: {
        borderColor: '#999',
        cursor: 'not-allowed'
      }
    }
  } else {
    return {}
  }
}

// visible disabled hidden
function controlBehavior (e, type = 'visible') {
  if (type === 'disabled' || type === 'hidden') {
    return e.stopPropagation()
  } else {
    return true
  }
}
