import { ObjectDeepSet, getDPR } from 'layersWp/utils/helper'

export default function Ruler(ruler) {
  const dpr = getDPR()
  this.dpr = dpr
  let options = {
    id: 'horizontalRuler',
    type: 'horizontal',
    height: 16,
    width: 3000,
    maxValue: 1500,
    minValue: -1500,
    start: 0,
    precision: 10,
    gutter: 10,
    orientation: 'horizontal',
    scale: {
      width: 2,
      height: 16,
      lineColor: '#E4E4E4',
      fontColor: '#999',
      fontSize: 10,
      per: 10
    },
    division: {
      width: 2,
      height: 5,
      lineColor: '#E4E4E4'
    }
  }
  ObjectDeepSet(options, ruler)
  this.options = options
  this.draw = () => {
    const {
      id,
      width,
      type,
      height,
      scale,
      gutter,
      minValue,
      maxValue,
      precision,
      division,
      start
    } = this.options
    // 初始化生成canvas，并设置宽高
    const rulerHTML = `<canvas id="${id}" style="width:${width}px;height:${height}px;"></canvas>`
    document.getElementById(id).outerHTML = rulerHTML
    const canvas = document.getElementById(id)
    this.canvas = canvas
    canvas.width = this.dpr * width
    canvas.height = this.dpr * height
    const ctx = canvas.getContext('2d')
    if (type === 'horizontal') {
      // 画尺子
      // 从start开始画（非常关键）
      ctx.translate(-start * getDPR(), 0)
      const per = precision * scale.per
      for (let i = minValue, j = 0; i <= maxValue; i += precision, j++) {
        if (i % per === 0) {
          drawXScale(ctx, j * gutter, scale, i)
        } else {
          drawXDivision(ctx, j * gutter, division)
        }
      }
      // 画横线
      drawLine({
        ctx,
        start: { x: 0, y: canvas.height },
        end: { x: maxValue, y: canvas.height }
      })
    } else if (type === 'vertical') {
      // 画尺子
      // 从start开始画（非常关键）
      ctx.translate(0, -start * getDPR())
      const per = precision * scale.per
      for (let i = minValue, j = 0; i <= maxValue; i += precision, j++) {
        if (i % per === 0) {
          drawYScale(ctx, j * gutter, scale, division, i)
        } else {
          drawYDivision(ctx, j * gutter, division)
        }
      }
      // 画竖线
      drawLine({
        ctx,
        start: { x: canvas.width / getDPR(), y: 0 },
        end: { x: canvas.width / getDPR(), y: maxValue }
      })
    }
    // 监听mouseover事件
    canvas.onmousemove = e => {
      // 尺子值
      const { type, gutter, precision, start } = this.options
      const val =
        Math.ceil(
          ((type === 'horizontal' ? e.offsetX : e.offsetY) / gutter) * precision
        ) + start
      typeof this.onMouseMove === 'function' && this.onMouseMove(e, val)
    }
    // 监听mouseout事件
    canvas.onmouseout = () => {
      typeof this.onMouseOut === 'function' && this.onMouseOut()
    }
    // 监听点击事件
    canvas.onclick = e => {
      // 尺子值
      const { type, gutter, precision, start } = this.options
      const val =
        Math.ceil(
          ((type === 'horizontal' ? e.offsetX : e.offsetY) / gutter) * precision
        ) + start
      typeof this.onClick === 'function' && this.onClick(e, val)
    }
  }
  this.reDraw = function(ruler) {
    ObjectDeepSet(this.options, ruler)
    const {
      id,
      type,
      scale,
      height,
      width,
      gutter,
      minValue,
      maxValue,
      precision,
      division,
      start
    } = this.options
    const canvas = this.canvas
    const ctx = canvas.getContext('2d')
    canvas.width = this.dpr * width
    canvas.height = this.dpr * height
    document.getElementById(id).style.width = width + 'px'
    document.getElementById(id).style.height = height + 'px'
    // 清除canvas
    ctx.clearRect(0, 0, canvas.width, canvas.height)
    if (type === 'horizontal') {
      // 画尺子
      ctx.translate(-start * getDPR(), 0)
      const per = precision * scale.per
      for (let i = minValue, j = 0; i <= maxValue; i += precision, j++) {
        if (i % per === 0) {
          drawXScale(ctx, j * gutter, scale, i)
        } else {
          drawXDivision(ctx, j * gutter, division)
        }
      }
      // 画横线
      drawLine({
        ctx,
        start: { x: 0, y: canvas.height / getDPR() },
        end: { x: maxValue, y: canvas.height / getDPR() }
      })
    } else if (type === 'vertical') {
      // 画尺子
      ctx.translate(0, -start * getDPR())
      const per = precision * scale.per
      for (let i = minValue, j = 0; i <= maxValue; i += precision, j++) {
        if (i % per === 0) {
          drawYScale(ctx, j * gutter, scale, division, i)
        } else {
          drawYDivision(ctx, j * gutter, division)
        }
      }
      // 画竖线
      drawLine({
        ctx,
        start: { x: canvas.width / getDPR(), y: 0 },
        end: { x: canvas.width / getDPR(), y: maxValue }
      })
    }
  }
}

function drawYScale(ctx, y, scale, division, text = '1') {
  // 2x像素
  const width = ctx.canvas.width / getDPR()
  drawLine({
    ctx,
    start: { x: width, y },
    end: { x: width - scale.height, y },
    lineWidth: scale.width,
    strokeStyle: scale.lineColor
  })
  ctx.save()
  ctx.translate((width - division.height - 2) * getDPR(), (y - 10) * getDPR())
  ctx.rotate((-90 * Math.PI) / 180)
  drawText({
    ctx,
    text,
    x: 0,
    y: 0,
    fontSize: scale.fontSize,
    fillStyle: scale.fontColor
  })
  ctx.restore()
}

function drawYDivision(ctx, y, division) {
  // 2x像素
  const width = ctx.canvas.width / getDPR()
  drawLine({
    ctx,
    start: { x: width, y },
    end: { x: width - division.height, y },
    lineWidth: division.width,
    strokeStyle: division.lineColor
  })
}

function drawXScale(ctx, x, scale, text = '1') {
  // 2x像素
  const height = ctx.canvas.height / getDPR()
  drawLine({
    ctx,
    start: { x, y: height },
    end: { x, y: height - scale.height },
    lineWidth: scale.width,
    strokeStyle: scale.lineColor
  })
  drawText({
    ctx,
    text,
    x: x + 3,
    y: scale.height - 6,
    fontSize: scale.fontSize,
    fillStyle: scale.fontColor,
    textAlign: 'left'
  })
}

// 用1倍去算
function drawXDivision(ctx, x, division) {
  // 2x像素
  const height = ctx.canvas.height / getDPR()
  drawLine({
    ctx,
    start: { x, y: height },
    end: { x, y: height - division.height },
    lineWidth: division.width,
    strokeStyle: division.lineColor
  })
}

// 用dpr去画
function drawLine({
  ctx,
  start = { x: 0, y: 0 },
  end = { x: 0, y: 0 },
  lineWidth = 1,
  strokeStyle = '#E4E4E4'
}) {
  const dpr = getDPR()
  ctx.beginPath()
  ctx.moveTo(dpr * start.x, dpr * start.y)
  ctx.lineWidth = dpr * lineWidth
  ctx.lineTo(dpr * end.x, dpr * end.y)
  ctx.strokeStyle = strokeStyle
  ctx.stroke()
}

// 用dpr去画
function drawText({
  ctx,
  text,
  x,
  y,
  fontSize = 12,
  fontFamily = 'serif',
  fillStyle = '#000',
  textAlign = 'center'
}) {
  const dpr = getDPR()
  ctx.textAlign = textAlign
  ctx.fillStyle = fillStyle
  ctx.font = `bold ${dpr * fontSize + 'px'} ${fontFamily}`
  ctx.fillText(text, dpr * x, dpr * y)
}
