import React, { Component } from 'react'
import uuidv4 from 'uuid/v4'
import { DragSource } from 'react-dnd'
import BaseAttrs from '../attrs'
import { inject } from 'mobx-react'
import { getNumber, deepClone } from 'layersWp/utils/helper'
import { sceneUniqueId } from 'layersWp/config'
function itemWrapper({
  type,
  defaultAttrs,
  screenshot,
  onDragIntoScene = () => {},
  verticalMiddle = false,
  horizontalCenter = false
} = {}) {
  !type && new Error('缺少必传参数type')
  !defaultAttrs && new Error('缺少必传参数defaultAttrs')
  !screenshot && new Error('缺少必传参数screenshot')
  return function ItemDecorator(Inner) {
    window.__itemsCount = {}
    @inject('WPLayersStore')
    @DragSource(
      type,
      {
        beginDrag: (props, monitor, component) => {
          // 返回的对象用于描述正在拖拽的item
          return {
            targetId: uuidv4().slice(0, 8),
            widgetType: type
          }
        },
        endDrag: (props, monitor, component) => {
          if (!monitor.didDrop()) {
            // 未拖拽至舞台中
            return false
          } else {
            // 获取场景inner的Rect
            const SceneInnerRect = document
              .getElementById(sceneUniqueId)
              .getBoundingClientRect()
            let attrs = deepClone(defaultAttrs)
            // 拖拽至舞台中
            // merge拖拽结果与默认配置融合后存入store

            // width, height, left, top属性%转px
            Object.keys(attrs.style)
              .filter(
                key => ['width', 'height', 'left', 'top'].indexOf(key) !== 1
              )
              .forEach(key => {
                if (
                  typeof attrs.style[key] === 'string' &&
                  attrs.style[key].indexOf('%') !== -1
                ) {
                  switch (key) {
                    case 'width':
                    case 'left':
                      attrs.style[key] =
                        (getNumber(SceneInnerRect.width) *
                          getNumber(attrs.style[key])) /
                          100 +
                        'px'
                      break
                    case 'height':
                    case 'top':
                      attrs.style[key] =
                        (getNumber(SceneInnerRect.height) *
                          getNumber(attrs.style[key])) /
                          100 +
                        'px'
                      break
                    default:
                      break
                  }
                }
              })

            // 此处坐标为鼠标落点相对于舞台的坐标
            attrs.style = Object.assign({}, BaseAttrs.style, attrs.style, {
              left:
                monitor.getDropResult().coordRelScene.x -
                getNumber(attrs.style.width) / 2 +
                'px',
              top:
                monitor.getDropResult().coordRelScene.y -
                getNumber(attrs.style.height) / 2 +
                'px'
            })

            // 水平居中处理
            if (horizontalCenter) {
              Object.assign(attrs.style, {
                left:
                  (SceneInnerRect.width - getNumber(attrs.style.width)) / 2 +
                  'px'
              })
            }

            // 垂直居中处理
            if (verticalMiddle) {
              Object.assign(attrs.style, {
                top:
                  (SceneInnerRect.height - getNumber(attrs.style.height)) / 2 +
                  'px'
              })
            }

            // 将name属性根据type以个数为维度进行重新命名
            window.__itemsCount[type]
              ? window.__itemsCount[type]++
              : (window.__itemsCount[type] = 1)
            attrs.name += window.__itemsCount[type]

            // 获取targetId
            const { targetId } = monitor.getItem()
            // 为部件属性添加唯一id
            attrs.id = targetId
            // 将部件添加至场景
            props['WPLayersStore'].addItem({
              ...monitor.getItem(),
              [type]: attrs
            })

            // onDragIntoScene钩子
            Promise.resolve({ targetId }).then(onDragIntoScene)
          }
        }
      },
      (connect, monitor) => ({
        // drag-dnd内置高阶组件。用于关联VDom与真实Dom（即被拖拽dom），使其能够被拖拽，可以暂时理解为给dom绑定拖拽事件。
        connectDragSource: connect.dragSource(),
        // drag-dnd内置高阶组件。用于generate拖拽过程中的预览图也就是screenshot，该引擎中使用图片来实现。
        connectDragPreview: connect.dragPreview()
      })
    )
    class Item extends Component {
      componentDidMount() {
        const { connectDragPreview } = this.props
        const { src, offsetX, offsetY } = screenshot

        const img = new window.Image()
        img.src = src
        img.onload = () =>
          connectDragPreview(img, {
            offsetX,
            offsetY
          })
      }
      render() {
        const { connectDragSource } = this.props
        return connectDragSource(
          <div>
            <Inner />
          </div>
        )
      }
    }

    return Item
  }
}

export default itemWrapper
