import React from 'react'

const border = '1px dashed rgb(255, 82, 82)'
const length = '-1000px'
const zIndex = 101
const position = 'absolute'
const pointerEvents = 'none'

/**
 * 如下
 * ----------------
 */
export function VerticalIndicator ({ left, right, ...rest }) {
  return (
    <div
      style={{
        position,
        left: left || length,
        right: right || length,
        borderBottom: border,
        zIndex,
        pointerEvents,
        ...rest
      }}
    />
  )
}

/**
 * 如下
 * |
 * |
 * |
 * |
 * |
 * |
 * |
 */
export function HorizontalIndicator ({ top, bottom, ...rest }) {
  return (
    <div
      style={{
        position,
        top: top || length,
        bottom: bottom || length,
        borderLeft: border,
        zIndex,
        pointerEvents,
        ...rest
      }}
    />
  )
}
