import React, { Component } from 'react'
import { Form, Select, Switch } from 'antd'
import { formItemProps } from './helper'
import { observer } from 'mobx-react'
import { PopupType } from 'layersWp/utils/itemType'
import store from 'layersWp/store'
import Divider from 'layersWp/constructors/fc/divider'

const Option = Select.Option
const FormItem = Form.Item

const normals = ['link', 'layer']

@observer
export default class JumpCom extends Component {
  componentWillReact = () => {
    let type = this.props.target.jump.type
    if (normals.indexOf(type) === -1) {
      // 如果选为无，则设为转化置为0
      this.props.handleChange({ 'jump.isCoversion': 0 })
    }
  }
  render() {
    const { target, handleChange, option } = this.props
    // target属性是当前正在被编辑部件，由Editor高阶组件传入
    return (
      <React.Fragment>
        <Form layout="inline">
          <FormItem label="跳转方式" {...formItemProps}>
            <Select
              value={target.jump.type}
              onChange={value => handleChange({ 'jump.type': value })}
            >
              {option.hideNone ? '' : <Option value="none">无</Option>}
              <Option value="link">跳转链接</Option>
              {option.hideLayer ? '' : <Option value="layer">跳转场景</Option>}
            </Select>
          </FormItem>
        </Form>
        {target.jump.type === 'layer' && (
          <Form layout="inline">
            <FormItem
              label="选择场景"
              {...formItemProps}
              style={{ ...formItemProps.style, paddingBottom: 7 }}
            >
              <Select
                value={target.jump.layerId}
                onChange={value => handleChange({ 'jump.layerId': value })}
              >
                {[...store.WPLayersStore.layerList].map((item, index) => {
                  if (
                    item.layerId !== store.WPLayersStore.currentLayer.layerId
                  ) {
                    return (
                      <Option key={index} value={item.layerId}>
                        {item.name}
                      </Option>
                    )
                  }
                })}
              </Select>
            </FormItem>
          </Form>
        )}
        {normals.indexOf(target.jump.type) !== -1 &&
          store.WPLayersStore.currentLayer.isMain && (
          <React.Fragment>
            {option ? !option.noDivider && <Divider /> : <Divider />}
            <Form layout="inline">
              {/* <FormItem label="设为转化" {...formItemProps}>
                <Switch
                  checked={
                    target.jump.isCoversion === undefined
                      ? true
                      : Boolean(target.jump.isCoversion)
                  }
                  onChange={value =>
                    handleChange({ 'jump.isCoversion': value ? 1 : 0 })
                  }
                />
              </FormItem> */}
              <FormItem label="设为计费" {...formItemProps}>
                <Switch
                  checked={Boolean(target.jump.isBilling)}
                  onChange={value =>
                    handleChange({ 'jump.isBilling': value ? 1 : 0 })
                  }
                />
              </FormItem>
            </Form>
          </React.Fragment>
        )}
      </React.Fragment>
    )
  }
}
