import React, { Component } from 'react'
import { inject, observer } from 'mobx-react'
import { action } from 'mobx'
import BasicAttrs from './basic-attrs'
import WidgetName from './widget-name'
import FixedAttr from './fixed-attr'
import Animation from './animation'
import Jump from './jump'
import FixedPosition from './fixed-position'
import Event from './event'
import Action from './action'
import store from 'layersWp/store'

export default function editorWrapper({ type, basic = {}, attrs = {} }) {
  return function EditorDecorator(Inner) {
    @inject('WPLayersStore')
    @observer
    class Editor extends Component {
      handleChange = (changed = {}) => {
        action(this.props.WPLayersStore.changeItemProps)(changed)
      }
      handleArrayChange = (...args) => {
        action(this.props.WPLayersStore.mutateArrayProp)(...args)
      }
      render() {
        const target = this.props[type]
        const { eventAttrs, actionAttrs } = attrs
        return (
          <Inner
            handleChange={this.handleChange}
            target={target}
            BasicAttrsCom={
              <BasicAttrs
                target={target}
                basic={basic}
                handleChange={this.handleChange}
              />
            }
            BasicAttrsComponent={props => {
              return (
                <BasicAttrs
                  target={target}
                  basic={basic}
                  handleChange={this.handleChange}
                  {...props}
                />
              )
            }}
            WidgetNameCom={
              <WidgetName target={target} handleChange={this.handleChange} />
            }
            FixedAttrCom={
              <FixedAttr target={target} handleChange={this.handleChange} />
            }
            JumpCom={
              <Jump
                target={target}
                handleChange={this.handleChange}
                option={{
                  ...basic.jump
                }}
              />
            }
            FixedPosition={
              <FixedPosition target={target} handleChange={this.handleChange} />
            }
            AnimationCom={
              <Animation
                target={target}
                handleChange={this.handleChange}
              />
            }
            EventCom={
              <Event target={target} handleChange={this.handleChange} type={type} eventAttrs={eventAttrs} />
            }
            ActionCom={
              <Action target={target} handleChange={this.handleChange} handleArrayChange={this.handleArrayChange} type={type} actionAttrs={actionAttrs} />
            }
          />
        )
      }
    }

    return Editor
  }
}
