export const formItemProps = {
  labelCol: { span: 6 },
  wrapperCol: { span: 17 },
  colon: false,
  style: { width: '100%', fontSize: '12px' }
}

export const formItemInnerProps = {
  style: { minHeight: '39px' }
}

export const getNumber = function getNumber (str) {
  if (typeof str === 'string') {
    const arr = str.match(/[-|0-9][0-9]*/)
    return arr && arr[0] ? parseInt(arr[0], 10) : 0
  } else {
    return str
  }
}

// 用于px单位的InputNumber
export const pxFormatter = {
  formatter: v => `${v}px`,
  parser: v => getNumber(v)
}

// 用于旋转的InputNumber
export const rotateFormatter = {
  formatter: v => `${v}°`,
  parser: v => getNumber(v)
}
