import React, { Component } from 'react'
import { Row, Col, Select, InputNumber } from 'antd'
import { observer, inject } from 'mobx-react'
import { pxFormatter } from './helper'
const Option = Select.Option
@inject('WPLayersStore')
@observer
export default class FixedAttr extends Component {
  render() {
    const { target, handleChange } = this.props
    const { dpr } = this.props.WPLayersStore.scene
    return (
      <React.Fragment>
        <Row type="flex" align="middle" style={{ marginBottom: '13px' }}>
          <Col offset={1} span={5} style={{ fontSize: 12 }}>
            宽度距离
          </Col>
          <Col span={8}>
            <Select
              value={target.fixed.horizontal}
              style={{ width: '100%' }}
              onChange={value => {
                handleChange({
                  ...(value === 'right'
                    ? {
                      'style.left': 'auto',
                      'style.right': '0px',
                      'fixed.horizontal': 'right'
                    }
                    : {
                      'style.left': '0px',
                      'style.right': 'auto',
                      'fixed.horizontal': 'left'
                    })
                })
              }}
            >
              <Option value="left">相对左侧</Option>
              <Option value="right">相对右侧</Option>
            </Select>
          </Col>
          <Col offset={1} span={8}>
            <InputNumber
              value={parseFloat(target.style[target.fixed.horizontal]) * dpr}
              formatter={pxFormatter.formatter}
              parser={pxFormatter.parser}
              style={{ width: '100%' }}
              onChange={value => {
                handleChange({
                  [`style.${target.fixed.horizontal}`]: value / dpr + 'px'
                })
              }}
            />
          </Col>
        </Row>
        <Row type="flex" align="middle" style={{ marginBottom: '13px' }}>
          <Col offset={1} span={5} style={{ fontSize: 12 }}>
            高度距离
          </Col>
          <Col span={8}>
            <Select
              value={target.fixed.vertical}
              style={{ width: '100%' }}
              onChange={value => {
                handleChange({
                  ...(value === 'top'
                    ? {
                      'style.bottom': 'auto',
                      'style.top': '0px',
                      'fixed.vertical': 'top'
                    }
                    : {
                      'style.bottom': '0px',
                      'style.top': 'auto',
                      'fixed.vertical': 'bottom'
                    })
                })
              }}
            >
              <Option value="top">相对顶部</Option>
              <Option value="bottom">相对底部</Option>
            </Select>
          </Col>
          <Col offset={1} span={8}>
            <InputNumber
              value={parseFloat(target.style[target.fixed.vertical]) * dpr}
              formatter={pxFormatter.formatter}
              parser={pxFormatter.parser}
              style={{ width: '100%' }}
              onChange={value => {
                handleChange({
                  [`style.${target.fixed.vertical}`]: value / dpr + 'px'
                })
              }}
            />
          </Col>
        </Row>
      </React.Fragment>
    )
  }
}
