import React, { Component } from 'react'
import { Form, Icon, Input, message } from 'antd'
import { formItemProps } from './helper'
import { observer } from 'mobx-react'
import copy from 'copy-to-clipboard'

const FormItem = Form.Item

@observer
export default class EventCom extends Component {
  constructor(props) {
    super(props)

    if (!this.props.target.events) {
      this.initStoreEvents()
    }
  }

  initStoreEvents() {
    const tmpEvents = this.props.eventAttrs || {}

    Object.keys(tmpEvents).map(key => {
      tmpEvents[key].pub = ''
    })

    this.props.handleChange({ 'events': tmpEvents })
  }

  handleGenEvent(eventName) {
    if (this.props.target.events && this.props.target.events[eventName].pub) {
      return
    }

    const eventKey = `${this.props.type}-${this.props.target.id}-${eventName}`

    this.props.handleChange({ [`events.${eventName}.pub`]: eventKey })

    copy(eventKey)

    message.info('事件码已拷贝到剪切板，将事件码粘贴到需要触发行为的组件处即可生效！')
  }

  handleDelEvent(eventName) {
    this.props.handleChange({ [`events.${eventName}.pub`]: '' })
  }

  componentDidUpdate (nextProps, nextState) {
    if (!this.props.target.events) {
      this.initStoreEvents()
    }
  }

  render() {
    const { target } = this.props

    return (
      <React.Fragment>
        <Form layout="inline">
          {
            target.events && Object.keys(target.events).map(key => {
              return (
                <FormItem {...formItemProps} label={target.events[key]['des']} key={key}>
                  <Input
                    style={{ width: 180 }}
                    disabled
                    value={target.events[key] && target.events[key].pub}
                  />
                  <Icon
                    type="plus"
                    style={{ marginLeft: 10, fontSize: 18 }}
                    onClick={this.handleGenEvent.bind(this, key)}
                  />
                  <Icon
                    type="close"
                    style={{ marginLeft: 10, fontSize: 18 }}
                    onClick={this.handleDelEvent.bind(this, key)}
                  />
                </FormItem>
              )
            })
          }
        </Form>
      </React.Fragment>
    )
  }
}
