import React, { Component } from 'react'
import { Form, Select, InputNumber } from 'antd'
import { formItemProps } from './helper'
import { observer } from 'mobx-react'

const FormItem = Form.Item
const Option = Select.Option

@observer
export default class FixedAttr extends Component {
  render() {
    const { target, handleChange } = this.props
    const { type, delay } = target.animation
    return (
      <React.Fragment>
        <FormItem label="动画设置" {...formItemProps}>
          <Select
            value={type}
            onChange={value => handleChange({ 'animation.type': value })}
          >
            <Option value={'none'}>无</Option>
            <Option value={'breathe'}>呼吸</Option>
            <Option value={'swing'}>摇摆</Option>
          </Select>
        </FormItem>
        <FormItem label="动画延迟" {...formItemProps}>
          <InputNumber
            value={delay}
            min={0}
            style={{ width: '48px' }}
            onChange={value => handleChange({ 'animation.delay': value })}
          />
          &nbsp;&nbsp;(S)
        </FormItem>
      </React.Fragment>
    )
  }
}
