import React, { Component } from 'react'
import { Form, Row, Col, Button, Select, Icon, Input } from 'antd'
import { formItemProps } from './helper'
import { observer } from 'mobx-react'

const { Option } = Select
const FormItem = Form.Item
let actionName = ''

@observer
export default class ActionCom extends Component {
  constructor(props) {
    super(props)

    if (!this.props.target.actions) {
      this.initStoreActions()
    }
  }

  initStoreActions() {
    this.props.handleChange({ 'actions': [] })
  }

  handleDelAction(index) {
    const { target } = this.props

    this.props.handleArrayChange(
      target.id,
      'actions',
      'splice',
      index,
      1
    )
  }

  handleChangeAction(index, e) {
    this.props.handleChange({ [`actions[${index}].sub`]: e.target.value })
  }

  handleChangeSelect(val) {
    actionName = val
  }

  handleAddAction() {
    if (!actionName) return

    const { target } = this.props
    const newAction = {
      action: actionName,
      sub: '',
      des: this.props.actionAttrs[actionName].des
    }

    this.props.handleArrayChange(
      target.id,
      'actions',
      'push',
      newAction
    )
  }

  componentDidUpdate (nextProps, nextState) {
    if (!this.props.target.actions) {
      this.initStoreActions()
    }
  }

  render() {
    const { target } = this.props

    return (
      <React.Fragment>
        <Form layout="inline">
          <Row style={{ marginBottom: '8px' }}>
            <Col offset={1} span={22}>
              <Select style={{ width: 150 }} placeholder="请选择行为" onChange={this.handleChangeSelect}>
                {
                  Object.keys(this.props.actionAttrs).map(key => {
                    return (
                      <Option value={key} key={key}>{this.props.actionAttrs[key].des}</Option>
                    )
                  })
                }
              </Select>
              <Button
                type="primary"
                style={{ width: 80, marginLeft: 10 }}
                onClick={this.handleAddAction.bind(this)}
              >
                添加
              </Button>
            </Col>
          </Row>
          {
            target.actions && target.actions.map((item, index) => {
              return (
                <FormItem {...formItemProps} label={item['des']} key={index}>
                  <Input
                    style={{ width: 180 }}
                    placeholder="请粘贴事件码"
                    defaultValue={item['sub']}
                    onChange={this.handleChangeAction.bind(this, index)}
                  />
                  <Icon
                    type="close"
                    style={{ marginLeft: 10, fontSize: 18 }}
                    onClick={this.handleDelAction.bind(this, index)}
                  />
                </FormItem>
              )
            })
          }
        </Form>
      </React.Fragment>
    )
  }
}
