/*
 * @Author: chenhaojie
 * @Date: 2018-07-20 17:47:32
 * @LastEditors: chenhaojie
 * @LastEditTime: 2019-03-14 17:24:08
 * @Description: 通用配置.
 * @Email: chenhaojie@tuia.cn
 */
import { message } from 'antd'
import uuidv4 from 'uuid/v4'

const uuidGen = () => uuidv4().split('-')[0]

export const uploadUrl = '/api/system/upload'
export const uploadVideoUrl = '/java/upload/video'

// !请勿修改此项配置
export const uploadBucket = '/jimu-web/'

// !请勿修改此项配置
export const imagePrefix =
  ['prod', 'pre'].indexOf(process.env.JIMU_ENV) !== -1
    ? '//yun.tuisnake.com'
    : '//yun.dui88.com'

export const staticResourcePrefix = '//yun.tuia.cn/tuia/jimo-web-pro'

export const h5RenderEndpoint = window.location.origin + '/preview'

export const draggingInScene = {
  // 舞台中拖动水平磁吸效果参数
  HorizontalDeviation: 10,
  // 舞台中拖动垂直磁吸效果参数
  VerticalDeviation: 10
}

export const sceneUniqueId = '___scene___id___'

export const bodyInnerUniqueId = '__body_inner__'

// body内需要参与计算的度量值
export const bodySizes = {
  // 用于定义可滚动区域Size，可理解为包裹着所有（ROADMAP，目前仅支持1个）Scene的wrapper
  sceneContainer: {
    width: 1550,
    height: 1150,
    inner: {
      initWidth: 375,
      initHeight: 603,
      maxHeight: 603,
      minHeight: 603,
      minWidth: 375,
      maxWidth: 375
    }
  },
  corner: {
    size: 16
  }
}

// (任何组件库)通用上传beforeUpload高阶函数
export const beforeUploadGen = function beforeUploadGen({
  mimeTypes = ['image/jpeg', 'image/png', 'image/gif'],
  maxSize = 0.5,
  pixel,
  onEnd = () => {},
  /**
   * 20200414新增 resetFileName 默认为true 需要重置文件名
   * 应产品要求需要对非规则字符做处理，增加该字段将传入文件名进行重置
   */
  resetName = true
} = {}) {
  return function onBeforeUpload(file) {
    // 重置文件名，因为file.name是个readonly的属性，因此生成新的文件返回上传
    let newFileInstance = file
    if (resetName) {
      const rawFileName = file.name
      const fileName = `${uuidGen()}-${new Date().getTime()}${rawFileName.substring(
        rawFileName.lastIndexOf('.')
      )}`
      newFileInstance = new File([file], fileName, { type: file.type })
      // 记录原文件名字，当需要使用原文件名时可以访问到
      newFileInstance.rawName = rawFileName
    }

    let isType = true
    if (mimeTypes) {
      if (mimeTypes instanceof Array) {
        isType = mimeTypes.indexOf(file.type) !== -1
      } else if (typeof mimeTypes === 'string') {
        isType = file.type === mimeTypes
      }

      if (!isType) {
        message.error(`上传类型不符`)
      }
    }

    let limitSize = true
    if (maxSize) {
      limitSize = file.size / 1024 / 1024 < maxSize
      if (!limitSize) {
        message.error(`上传大小限制${maxSize}MB`)
      }
    }

    const beforeUploadHandleResult =
      isType && limitSize
        ? Promise.resolve(newFileInstance)
        : Promise.reject(new Error(''))

    if (pixel) {
      return Promise.all([
        beforeUploadHandleResult,
        checkImageSize(file, pixel)
      ])
    }
    onEnd({
      typeError: !isType,
      sizeError: !limitSize
    })
    return beforeUploadHandleResult
  }
}

// antd通用上传onChange高阶函数
export const uploadStatusChangeGen = function uploadStatusChangeGen(
  userHandler
) {
  return function onUploadChange(info) {
    if (info.file.status === 'error') {
      message.error(`${info.file.name}。文件上传失败`)
    }
    let infoWrappered
    if (info.file.status === 'done') {
      infoWrappered = {
        file: {
          name: info.file.response.data.split('/').pop(),
          status: 'done'
        }
      }
    } else {
      infoWrappered = info
    }
    userHandler(infoWrappered)
  }
}
// 校验图片的大小是否合规
function checkImageSize(file, imgTypeSize) {
  return new Promise(function(resolve, reject) {
    function check(width, height) {
      if (
        (width === imgTypeSize.width || !imgTypeSize.width) &&
        (height === imgTypeSize.height || !imgTypeSize.height)
      ) {
        resolve(file)
      } else {
        message.error(
          '图片大小不对，要求尺寸为' +
            (imgTypeSize.width || '宽度不限') +
            '*' +
            (imgTypeSize.height || '高度不限') +
            ' 像素'
        )
        reject(new Error())
      }
    }
    // 读取图片数据
    if (typeof window.FileReader === 'function') {
      // 读取图片数据
      const reader = new window.FileReader()
      reader.onload = function(e) {
        const data = e.target.result
        // 加载图片获取图片真实宽度和高度
        const image = new window.Image()
        image.onload = function() {
          const width = image.width
          const height = image.height
          check(width, height)
        }
        image.src = data
      }
      reader.readAsDataURL(file)
    } else {
      message.error(
        '你的浏览器不支持图片大小判断，请更换现代浏览器，例如Chrome'
      )
    }
  })
}
// tuia upload 统一参数入口
export const uploadParamsGen = function uploadParamsGen() {
  return {
    name: 'file',
    action: uploadUrl,
    data: {
      path: uploadBucket,
      isTinypng: false
    }
  }
}

export const uploadVideoParamsGen = data => ({
  name: 'file',
  action: uploadVideoUrl,
  data
})
