import { getLocalStorage } from 'layersWp/utils/helper'
import common from 'layers/lib/common'
const prefix = '/java/layer'

export const saveJson = ({ tagIds }, json, thumbnailUrl) => {
  const skin = getLocalStorage('skin')
  return common.fetch(
    `${prefix}/save`,
    Object.assign(
      {
        code: JSON.stringify(json),
        skinName: json.page.name,
        isDeleted: 0,
        tagIds
      },
      { ...(skin || {}) },
      thumbnailUrl ? { image: thumbnailUrl } : {}
    ),
    'post',
    {
      isJson: true,
      isLoading: true
    }
  )
}

export const getJson = id => {
  return new Promise(resolve => {
    common
      .fetch(`${prefix}/queryById`, {
        id
      })
      .then(res => {
        if (res.code === '0') {
          resolve({
            code: 0,
            data: {
              pageJson: res.data.code,
              skinType: res.data.skinType,
              skinTags: (res.data.tagInfo || []).map(tag => tag.tagId)
            }
          })
        }
      }, resolve)
      .catch(resolve)
  })
}

export const getTemplateJson = id => {
  return new Promise(resolve => {
    common
      .fetch(`${prefix}/template/queryById`, {
        id
      })
      .then(res => {
        if (res.code === '0') {
          resolve({
            code: 0,
            data: {
              pageJson: res.data.code,
              skinDesc: res.data.skinDesc,
              skinTags: (res.data.tagInfo || []).map(tag => tag.tagId)
            }
          })
        }
      }, resolve)
      .catch(resolve)
  })
}

export const editJson = ({ id, tagIds }, json, thumbnailUrl) => {
  return common.fetch(
    `${prefix}/save`,
    Object.assign(
      {
        id,
        tagIds,
        code: JSON.stringify(json),
        skinName: json.page.name,
        isDeleted: 0
      },
      thumbnailUrl ? { image: thumbnailUrl } : {}
    ),
    'post',
    {
      isJson: true
    }
  )
}

export const editTemplate = ({ id, tagIds }, json, thumbnailUrl, desc) => {
  return common.fetch(
    `${prefix}/template/save`,
    Object.assign(
      {
        id,
        tagIds,
        code: JSON.stringify(json),
        skinName: json.page.name,
        isDeleted: 0,
        skinDesc: desc
      },
      thumbnailUrl ? { image: thumbnailUrl } : {}
    ),
    'post',
    {
      isJson: true
    }
  )
}

export const getTags = () => {
  return common.fetch(`${prefix}/template/tag`)
}
