import React from 'react'
import { Spin } from 'antd'
import { staticResourcePrefix } from 'layersWp/config'
import { hot } from 'react-hot-loader'
import { autoLogin } from '../api'
import Utils from 'layers/lib/utils'
import { hashHistory } from 'react-router'
import { setLocalStorage } from 'layersWp/utils/helper'

class Login extends React.Component {
  state = {
    isAutoLogin: true
  }

  componentDidMount() {
    const token = Utils.getUrlParams('token')
    if (token) {
      autoLogin(token).then((res) => {
        if (res.data) {
          setLocalStorage('nickname', res.data)
        }
        hashHistory.replace('/home')
      })
    } else {
      this.setState({
        isAutoLogin: false
      })
    }
  }
  render() {
    const { isAutoLogin } = this.state
    return (
      <div style={{ width: '100%', height: '100vh', display: 'flex', alignItems: 'center', justifyContent: 'center' }}>
        {isAutoLogin ? (
          <Spin
            indicator={<img style={{ width: 100, height: 100 }} src={`${staticResourcePrefix}/jimu_loading_new.gif`} />}
            tip="自动登录中..."
          />
        ) : (
          '仅支持广告后台与广告管理后台'
        )}
      </div>
    )
  }
}
export default hot(module)(Login)
