import React, { Component } from 'react'
import { DatePicker, Button, Input, Form, Select } from 'antd'
import { observer, inject } from 'mobx-react'
import styles from './index.less'
import moment from 'moment'
import { jumpIntoWorkplace, jumpActionsMapping } from 'layersWp/utils/util'
import LayerTypeModal from 'layers/components/layer-type-select'
import { getTags } from '../../workplace/api/index'
const { RangePicker } = DatePicker
// const { Option } = Select

@inject('WPLayersStore')
@observer
class Search extends Component {
  constructor() {
    super(...arguments)
    this.state = {
      states: [
        {
          label: '全部状态',
          value: 0
        },
        {
          label: '未审核',
          value: 1
        },
        {
          label: '审核中',
          value: 2
        },
        {
          label: '审核通过',
          value: 3
        },
        {
          label: '审核拒绝',
          value: 4
        }
      ],
      types: [
        {
          label: '全部类型',
          value: 0
        },
        {
          label: '贷款',
          value: 1
        },
        {
          label: '信用卡',
          value: 2
        },
        {
          label: '保险',
          value: 3
        },
        {
          label: 'p2p',
          value: 4
        }
      ],
      tags: [],
      inputValue: '',
      visible: false,
      startDate: '',
      endDate: '',
      // 是否显示展开/收起按钮
      showSearchOpenCloseButton: false,
      // 展开/隐藏搜索条件，默认隐藏
      showAllSearchOptions: false
    }
    // 记录搜索控件容器用于获取高度判断是否需要显示展开/收起按钮
    this.searchControlsFromRef = React.createRef()
  }

  componentDidMount() {
    const { clientHeight, scrollHeight } = this.searchControlsFromRef.current
    this.setState({
      showSearchOpenCloseButton: scrollHeight > clientHeight
    })
    getTags().then(res => {
      this.setState({ tags: res.data })
    })
  }

  handleInputChange = (() => {
    let timer = null
    return e => {
      e.persist()
      this.setState({
        inputValue: e.target.value
      })
      let fn = e => {
        let value = e.target.value
        /* eslint-disable-next-line */
        let isNum = +value == value
        if (isNum) {
          this.props.handleChange({
            id: e.target.value,
            skinName: '',
            currentPage: 1
          })
        } else {
          this.props.handleChange({
            skinName: e.target.value,
            id: '',
            currentPage: 1
          })
        }
      }
      clearTimeout(timer)
      timer = setTimeout(() => {
        fn(e)
      }, 400)
    }
  })()
  onTimeChange = (_, dateString) => {
    // 当清除日期选择器数据时dateString中的值会被置为""  此时再做moment操作会返回"Invalid date"
    dateString[1] = dateString[1] ?  moment(dateString[1]).add(1, 'days').format('YYYY-M-D') : "";
    this.setState({ startDate: dateString[0], endDate: dateString[1] })
  }
  create = () => {
    this.setState({ visible: true })
  }
  handleSearch = () => {
    const { startDate, endDate } = this.state
    this.props.form.validateFields((err, values) => {
      if (err) return console.error(err)
      this.props.handleChange({ startDate, endDate, ...values, currentPage: 1 })
    })
  }

  toggleShowAllSearchOptions = () => {
    this.setState(previousState => {
      return {
        showAllSearchOptions: !previousState.showAllSearchOptions
      }
    })
  }
  render() {
    // const { states, types } = this.state
    // const day = 1000 * 60 * 60 * 24

    const {
      visible,
      showAllSearchOptions,
      showSearchOpenCloseButton, 
      tags
    } = this.state
    const { getFieldDecorator } = this.props.form
    return (
      <div className={styles['search-wrapper']}>
        <LayerTypeModal
          visible={visible}
          onSelect={skin => {
            jumpIntoWorkplace(null, jumpActionsMapping.CREATE_LAYER, skin)
            this.props.WPLayersStore.setSkinType(skin.skinType)
          }}
          onCancel={() => {
            this.setState({ visible: false })
          }}
        />

        <div className={styles['first']}>
          {/* <Select className="__jm_select__" value={condition.state} style={{ width: 120 }} onChange={value => handleChange({ 'state': value })}>
            {states.map((item, index) => {
              return <Option key={index} value={item.value}>{item.label}</Option>
            })}
          </Select>
          <Select className="__jm_select__" value={condition.type} style={{ width: 120 }} onChange={value => handleChange({ 'type': value })}>
            {types.map((item, index) => {
              return <Option key={index} value={item.value}>{item.label}</Option>
            })}
          </Select> */}
          <RangePicker
            style={{ width: 216 }}
            ranges={{
              最近一天: [moment().subtract(1, 'days'), moment()],
              最近七天: [moment().subtract(7, 'days'), moment()],
              最近一月: [moment().subtract(1, 'months'), moment()],
              最近三月: [moment().subtract(3, 'months'), moment()]
            }}
            onChange={this.onTimeChange}
          />
        </div>
        <div className={styles['last']}>
          {/* <JimuInput1
            placeholder="输入ID/名称"
            value={inputValue}
            onChange={this.handleInputChange}
          />
          <TuiaIcon
            type="icon-nav_list"
            className={`${styles['list-icon']} ${styles['active']}`}
          />
          <TuiaIcon type="icon-nav_card" className={styles['card-icon']} /> */}
          <div
            className={`${showAllSearchOptions ? styles['open'] : ''} ${
              styles['search-controls-wrap']
            }`}
            ref={this.searchControlsFromRef}
          >
            <Form layout="inline">
            <Form.Item label="标签">
              {getFieldDecorator('tagId', { initialValue: '' })(
                <Select
                  style={{ width: 100 }}
                  showSearch
                  filterOption={(input, option) =>
                    option.props.children
                      .toLowerCase()
                      .indexOf(input.toLowerCase()) >= 0
                  }
                >
                  {tags.map(tag => (
                    <Select.Option value={tag.tagId}>
                      {tag.tagName}
                    </Select.Option>
                  ))}
                </Select>
              )}
            </Form.Item>
              <Form.Item label="类型">
                {getFieldDecorator('type', { initialValue: '' })(
                  <Select style={{ width: 100 }}>
                    <Select.Option value={51}>增值广告</Select.Option>
                    <Select.Option value={61}>互动广告</Select.Option>
                  </Select>
                )}
              </Form.Item>
              <Form.Item label="名称">
                {getFieldDecorator('skinName', { initialValue: '' })(
                  <Input className={styles.input} />
                )}
              </Form.Item>
              <Form.Item label="ID">
                {getFieldDecorator('id', { initialValue: '' })(
                  <Input className={styles.input} />
                )}
              </Form.Item>
              <Form.Item label="用户">
                {getFieldDecorator('userName', { initialValue: '' })(
                  <Input className={styles.input} />
                )}
              </Form.Item>
            </Form>
          </div>
          {/* 展开收起搜索条件的按钮 */}
          {showSearchOpenCloseButton ? (
            <Button
              className={styles['toggle-show-btn']}
              onClick={this.toggleShowAllSearchOptions}
            >
              {showAllSearchOptions ? '收起' : '展开'}
            </Button>
          ) : null}
          <Button
            className={`${styles['search']} ${styles['new-page']}`}
            type="primary"
            onClick={this.handleSearch}
          >
            搜索
          </Button>
          <Button className={styles['new-page']} type="primary">
            <a href={this.props.jumpSlot.url}>{this.props.jumpSlot.text}</a>
          </Button>
          <Button
            className={styles['new-page']}
            type="primary"
            onClick={this.create}
          >
            新建弹层
          </Button>
        </div>
      </div>
    )
  }
}

export default Form.create()(Search)
