import React, { Component } from 'react'
import Header from './header'
import Search from './search'
import CardMode from './body/card-mode'
import styles from './index.less'
import { BackTop, Spin, Pagination } from 'antd'
import { hot } from 'react-hot-loader'
import { staticResourcePrefix } from 'layersWp/config'
import { getPages } from './api'
import NoData from './components/noData'

class Index extends Component {
  constructor() {
    super(...arguments)
    this.state = {
      mode: 'card',
      loading: false,
      firstLoaded: false,
      condition: {
        startDate: '',
        endDate: '',
        id: '',
        skinName: '',
        type: '',
        userName: '',
        currentPage: 1,
        pageSize: 10,
        tagId: ''
      },
      data: {},
      listData: [],
      total: 0
    }
  }
  componentDidMount() {
    this.handleChange()
  }
  _getPages() {
    return getPages(this.state.condition).then(res => {
      this.setState({
        listData: res.data.list,
        total: res.data.totalCount,
        loading: false,
        firstLoaded: true
      })
    })
  }
  handleChange = (changed = {}) => {
    this.setState(
      {
        condition: Object.assign({}, this.state.condition, changed),
        loading: true
      },
      this._getPages
    )
  }
  render() {
    const { condition, listData, loading, total, firstLoaded } = this.state
    return (
      <div className={styles['container']}>
        <Header />
        <Search
          condition={condition}
          handleChange={this.handleChange}
          jumpSlot={{ text: '我的弹层', url: '/layers#/home' }}
        />
        <Spin
          spinning={loading}
          indicator={
            <img
              style={{ width: 100, height: 100 }}
              src={`${staticResourcePrefix}/jimu_loading_new.gif`}
            />
          }
        >
          {!firstLoaded ? (
            <div style={{ height: 500 }} />
          ) : listData.length === 0 ? (
            <NoData />
          ) : (
            <div>
              <CardMode listData={listData} onChange={this.handleChange} />
              <Pagination
                defaultCurrent={1}
                current={condition.currentPage}
                total={+total}
                pageSize={condition.pageSize}
                onChange={p => this.handleChange({ currentPage: p })}
                style={{ marginTop: -70, textAlign: 'center' }}
              />
            </div>
          )}
        </Spin>
        <BackTop />
      </div>
    )
  }
}

export default hot(module)(Index)
