import React, { useState } from 'react'
import styles from './card.less'
import action from './action'
import PreviewH5 from 'components/preview-h5'
import permission from 'layers/lib/permission'

const {
  USE_TEMPLATE,
  EDIT_TEMPLATE,
  DELETE_TEMPLATE
} = action
const Card = ({ onOperate, info }) => {
  const [hovered, setHoverd] = useState(false)
  const handleClick = action => {
    onOperate(action, info)
  }
  const renderOpByPermission = () => {
    return [
      [
        <PreviewH5
          key="previewH5"
          id={info.id}
          url={location.origin+`/preview?id=${info.id}&type=template`}
          content={({ show }) => <div onClick={show}>预览模版</div>}
        />,
        'layer/template/preview'
      ],
      [
        <div key={USE_TEMPLATE} onClick={() => handleClick(USE_TEMPLATE)}>使用模版</div>,
        'layer/template/use'
      ],
      [
        <div key={EDIT_TEMPLATE} onClick={() => handleClick(EDIT_TEMPLATE)}>编辑模版</div>,
        'layer/template/edit'
      ],
      [
        <div key={DELETE_TEMPLATE} onClick={() => handleClick(DELETE_TEMPLATE)}>删除模版</div>,
        'layer/template/del'
      ]
    ].map(([op, code]) => permission.authRender(op, code))
  }
  return (
    <div className={styles.card_wrapper}>
      <div className={styles.card_item}>
        <figure>
          <div
            className={styles.img_wrapper}
            onMouseEnter={() => {
              setHoverd(true)
            }}
            onMouseLeave={() => {
              setHoverd(false)
            }}
          >
            <img src={info.image} alt="" />
            {hovered ? (
              <div className={styles.operate_wrapper}>
                {renderOpByPermission()}
              </div>
            ) : (
              ''
            )}
          </div>
          <figcaption>
            <div>名称：{info.skinName}</div>
            <div style={{ marginTop: 10 }}>描述：{info.skinDesc}</div>
          </figcaption>
        </figure>
      </div>
    </div>
  )
}
export default Card
