import React, { useState } from 'react'
import { Modal, message } from 'antd'
import { observer, inject } from 'mobx-react'
import styles from './card.less'
import Card from './card'
import action from './action'
import { deleteById } from '../api/index'
import { jumpIntoWorkplace, jumpActionsMapping } from 'layersWp/utils/util'
import LayerTypeModal from 'layers/components/layer-type-select'
import store from 'layersWp/store'
const {
  USE_TEMPLATE,
  EDIT_TEMPLATE,
  DELETE_TEMPLATE,
  PREVIEW_TEMPLATE
} = action

const deleteTemplate = (id, onChange) => {
  Modal.confirm({
    title: '确认删除么',
    content: '点击确认将删除',
    onOk: () => {
      deleteById(id).then(res => {
        message.success('删除成功')
        onChange && onChange()
      })
    }
  })
}
const CardList = ({ listData, onChange }) => {
  const [visible, setVisible] = useState(false)
  const [tempId, setTempId] = useState('')
  return (
    <div className={styles.card_list}>
      <LayerTypeModal
        visible={visible}
        onSelect={skin => {
          jumpIntoWorkplace(tempId, jumpActionsMapping.USE_TEMPLATE, skin)
          store.WPLayersStore.setSkinType(skin.skinType)
        }}
        onCancel={() => {
          setVisible(false)
        }}
      />
      {listData.map((v, i) => (
        <Card
          key={i}
          onOperate={(action, info) => {
            console.log(action, info)
            const { id } = info
            switch (action) {
              case USE_TEMPLATE:
                setVisible(true)
                setTempId(id)
                break
              case EDIT_TEMPLATE:
                jumpIntoWorkplace(id, jumpActionsMapping.EDIT_TEMPLATE)
                break
              case DELETE_TEMPLATE:
                deleteTemplate(id, onChange)
                break
              case PREVIEW_TEMPLATE:
                break
            }
          }}
          info={v}
        />
      ))}
    </div>
  )
}
export default CardList
