import common from 'layers/lib/common'

const prefix = '/java/layer'

export const getPages = condition => {
  return common.fetch(`${prefix}/template/query`, { ...condition }, 'get', {
    isJson: true
  })
}

export const deleteById = id => {
  return common.fetch(
    `/java/layer/template/save`,
    { id, isDeleted: 1 },
    'post',
    {
      isJson: true,
      isLoading: true
    }
  )
}
