import React, { Component } from 'react'
import styles from './index.less'
import PagePreview from './page-preview'
import DataPreview from './data-preview'
import Utils from 'layers/lib/utils'
import StatisticStore from './store'
import { getSceneData } from './api'
import { message } from 'antd'

export default class Statistic extends Component {
  state = {
    DataIsReady: false
  }
  componentDidMount() {
    let landId = Utils.getUrlParams('landId')
    if (landId) {
      StatisticStore.setLandId(landId)
      // 请求当前落地页数据
      getSceneData(landId).then(res => {
        if (res.code === '0') {
          let pageData = JSON.parse(res.data.html)
          this.handleData(pageData)
        }
      })
    } else {
      message.warn('无landId')
    }
  }
  handleData = pageData => {
    // 筛选出表单并存进store
    StatisticStore.setConditionForms(
      pageData.elements
        .filter(
          item =>
            item.type === 'form' ||
            (item.type === 'popup' && item.form && item.form.enable)
        )
        .map(item => ({
          id: item.id,
          name: item.name
        }))
    )
    // 存落地页名称
    StatisticStore.setLandName(pageData.page.name)
    // 生成组件关联关系
    let ComponentRelations = pageData.elements.map(item => {
      let base = {
        name: item.name,
        id: item.id
      }
      // 是否设为转化
      //! 这里为了兼容之前数据结构，将undefined人为认定为开启转化，这是产品逻辑
      if (item.type === 'form') {
        base.isCoversion =
          item.submitVerify &&
          item.submitVerify.jump &&
          (item.submitVerify.jump.isCoversion === undefined ||
            item.submitVerify.jump.isCoversion)
      } else {
        base.isCoversion =
          item.jump &&
          (item.jump.isCoversion === undefined || item.jump.isCoversion)
      }
      return base
    })
    // 自动跳转的关联关系
    ComponentRelations.push({
      name: '自动跳转',
      id: 'page$1234567890',
      isCoversion:
        pageData.page.autoJump.isCoversion === undefined ||
        pageData.page.autoJump.isCoversion
    })
    StatisticStore.setComponentRelations(ComponentRelations)
    this.setState({
      DataIsReady: true
    })
  }
  render() {
    return (
      <div className={styles['wrapper']}>
        <div className={styles['left']}>
          <PagePreview />
        </div>
        <div className={styles['right']}>
          {this.state.DataIsReady && <DataPreview />}
        </div>
      </div>
    )
  }
}
