import React, { Component } from 'react';
import { Table } from 'antd';
import { nanoid } from 'nanoid';
import PubSub from 'pubsub-js';
import { BIDataConditionsEvent } from '../../config/pbTopics';
import update from 'immutability-helper';
import { BIDataTableOptions } from '../../config';

export default class PVTable extends Component {
  handleTableChange = (pagination, filters, sorter) => {
    const prePager = this.props.pagination;
    // 如果切换页大小则重置current
    if (pagination.pageSize !== prePager.pageSize) {
      prePager.current = 1;
    } else {
      prePager.current = pagination.current;
    }
    PubSub.publish(BIDataConditionsEvent, {
      pagination: update(prePager, {
        current: {
          $set: pagination.current
        },
        pageSize: {
          $set: pagination.pageSize
        }
      }),
      _dataToFetch: ['table']
    });
  };
  render() {
    const { tableScrollHeight, tableScrollWidth } = this.props;
    const { data, columns, loading, pagination } = this.props;
    let containerLessThanTotalColumn =
      tableScrollWidth < columns.length * BIDataTableOptions.defaultWidth;
    let scroll = containerLessThanTotalColumn
      ? {
          x: BIDataTableOptions.defaultWidth * columns.length,
          y: tableScrollHeight
        }
      : undefined;
    return (
      <div
        style={{
          width: tableScrollWidth,
          margin: '0 auto'
        }}
        className="statistic-table"
      >
        <Table
          loading={loading}
          rowKey={() => nanoid()}
          pagination={Object.assign(
            {
              size: 'normal',
              showQuickJumper: true,
              pageSizeOptions: ['10', '20', '30'],
              showSizeChanger: true
            },
            pagination
          )}
          columns={columns}
          dataSource={data}
          onChange={this.handleTableChange}
          scroll={scroll}
        />
      </div>
    );
  }
}
