import common from 'layers/lib/common'
import { SitePrefix } from 'layers/config'
import { submitForm, getJavaSiteHost } from 'layers/lib/helper'
console.log(SitePrefix, 12)
export const getFormData = params => {
  return common.fetch(`${SitePrefix}/landData/landUserInfo`, params, 'get')
}

export const getBIData = params => {
  return common.fetch(`${SitePrefix}/landData/landStaticData`, params, 'get')
}

export const getBIChartData = params => {
  return common.fetch(`${SitePrefix}/landData/landStaticDataPUV`, params, 'get')
}

export const getSceneData = landId => {
  return common.fetch(`${SitePrefix}/land/query`, { id: landId }, 'get')
}

export const exportBIData = params => {
  submitForm({
    params,
    action: `//${getJavaSiteHost()}/landData/exportLandStaticData`
  })
}

export const exportFormData = params => {
  submitForm({
    params,
    action: `//${getJavaSiteHost()}/landData/exportLandUserInfo`
  })
}
