import React, { Component } from 'react'
import Header from './header'
import Search from '../template-board/search'
import ListMode from './body/list-mode'
import CardMode from './body/card-mode'
import styles from './index.less'
import { BackTop, Spin } from 'antd'
import { hot } from 'react-hot-loader'
import { staticResourcePrefix } from 'layersWp/config'
import { getPages } from './api'
import NoData from './components/noData'

class Index extends Component {
  constructor() {
    super(...arguments)
    this.state = {
      mode: 'list',
      loading: false,
      firstLoaded: false,
      condition: {
        skinName: '',
        type: '',
        // state: 0,
        // advertTradId: '',
        startDate: '',
        endDate: '',
        id: '',
        currentPage: 1,
        pageSize: 10,
        tagId: ''
      },
      data: {},
      listData: [],
      total: 0
    }
  }
  componentDidMount() {
    this.handleChange()
  }
  _getPages() {
    return getPages(this.state.condition).then(res => {
      this.setState({
        listData: res.data.list,
        total: res.data.totalCount,
        loading: false,
        firstLoaded: true
      })
    })
  }
  handleChange = (changed = {}) => {
    this.setState(
      {
        condition: Object.assign({}, this.state.condition, changed),
        loading: true
      },
      this._getPages
    )
  }
  render() {
    const {
      mode,
      condition,
      listData,
      loading,
      total,
      firstLoaded
    } = this.state
    return (
      <div className={styles['container']}>
        <Header />
        <Search
          condition={condition}
          handleChange={this.handleChange}
          jumpSlot={{ text: '使用模版', url: '/layers#/template' }}
        />
        <Spin
          spinning={loading}
          indicator={
            <img
              style={{ width: 100, height: 100 }}
              src={`${staticResourcePrefix}/jimu_loading_new.gif`}
            />
          }
        >
          {!firstLoaded ? (
            <div style={{ height: 500 }} />
          ) : listData.length === 0 ? (
            <NoData />
          ) : mode === 'list' ? (
            <ListMode
              listData={listData}
              total={+total}
              current={condition.currentPage}
              onChange={this.handleChange}
            />
          ) : (
            <CardMode
              listData={listData}
              total={total}
              current={condition.currentPage}
            />
          )}
        </Spin>
        <BackTop />
      </div>
    )
  }
}

export default hot(module)(Index)
