import React, { Component } from 'react'
import { staticResourcePrefix } from 'layersWp/config'
import styles from './index.less'
// import TuiaIcon from 'layersWp/constructors/fc/icon'
import { getLocalStorage } from 'layersWp/utils/helper'

export default class Header extends Component {
  render() {
    let lastName = '客'
    try {
      let nickname = getLocalStorage('nickname')
      nickname && (lastName = nickname[nickname.length - 1])
    } catch (e) {
      console.log(e)
    }
    return (
      <div className={styles['header-wrapper']}>
        <div className={styles['first']}>
          <img src={`${staticResourcePrefix}/logo_entire.png`} />
        </div>
        <div className={styles['last']}>
          <div className={styles['header-img']}>{lastName}</div>
          {/* <div className={styles['divider']} />
          <TuiaIcon type="icon-nav_signout" /> */}
        </div>
      </div>
    )
  }
}
