import React, { Component } from 'react'
import { List, message, Modal, Select, Spin, Input, Form, Tag } from 'antd'
import { observer, inject } from 'mobx-react'
import styles from './index.less'
import {
  deleteByLandPageId,
  searchUserByName,
  permissionSave,
  listPermission,
  saveTemplate,
  getJson
} from '../api'
import TuiaIcon from 'layersWp/constructors/fc/icon'
import PreviewH5 from 'components/preview-h5'
import { jumpIntoWorkplace, jumpActionsMapping } from 'layersWp/utils/util'
import { hashHistory } from 'react-router'
import { debounce } from 'lodash-es'
import permission from 'layers/lib/permission'
import { getLocalStorage } from 'layersWp/utils/helper'

import LayerTypeModal from 'layers/components/layer-type-select'
const { confirm } = Modal
const { Option } = Select

// const stateFilter = state => {
//   switch (state) {
//     default:
//     case 0:
//       return '未审核'
//   }
// }

const skinTypeMap = {
  '51': '增值广告弹层',
  '61': '互动广告弹层'
}
@inject('WPLayersStore')
@observer
export default class ListMode extends Component {
  constructor(props) {
    super(props)
    this.fetchUser = debounce(this.fetchUser, 800)
  }
  state = {
    visible: false,
    currentId: null,
    fetching: false,
    data: [],
    value: [],
    desc: '',
    templateVisible: false,
    templdescateName: '',
    item: {}
  }
  edit(pageId) {
    jumpIntoWorkplace(pageId, jumpActionsMapping.EDIT_LAYER)
  }
  copy(pageId) {
    this.setState({ typeVisible: true, pageId })
  }
  handlePreviewData(pageId) {
    hashHistory.push(`statistic?landId=${pageId}`)
  }
  delete = id => {
    confirm({
      title: '确认删除么',
      content: '点击确认将删除',
      onOk: () => {
        deleteByLandPageId(id).then(res => {
          message.success('删除成功')
          this.props.onChange()
        })
      }
    })
  }
  saveAsTemplate = () => {
    const {
      item: { id, image, tagInfo },
      templateName,
      desc
    } = this.state
    getJson(id).then(res => {
      saveTemplate({
        code: res.data.code,
        image,
        skinName: templateName,
        skinDesc: desc,
        tagIds: tagInfo && tagInfo.map(tag => tag.tagId)
      }).then(() => {
        this.setState({
          templateVisible: false
        })
        message.success('保存成功')
      })
    })
  }
  addTeamWork = id => {
    listPermission(id).then(res => {
      const { data } = res
      const value = (data || []).map(item => item.adminId)
      this.setState({
        visible: true,
        currentId: id,
        value,
        data
      })
    })
  }
  cancel = () => {
    this.setState({
      visible: false,
      currentId: null,
      fetching: false,
      data: [],
      value: []
    })
  }
  fetchUser = value => {
    this.setState({ data: [], fetching: true })
    searchUserByName(value).then(res => {
      const { data } = res
      this.setState({
        data,
        fetching: false
      })
    })
  }
  handleChange = value => {
    this.setState({
      value,
      fetching: false
    })
  }
  addUser = () => {
    const { currentId, value } = this.state
    permissionSave(currentId, value).then(res => {
      message.success('添加成功')
      this.setState({
        visible: false,
        currentId: null,
        fetching: false,
        data: [],
        value: []
      })
    })
  }
  render() {
    const { listData, total, current } = this.props
    const {
      visible,
      value,
      fetching,
      data,
      desc,
      templateName,
      templateVisible,
      typeVisible,
      pageId
    } = this.state

    // 上帝权限
    let isGod = getLocalStorage('__GOD__')

    return (
      <div className={styles['container']}>
        <LayerTypeModal
          visible={typeVisible}
          onSelect={skin => {
            jumpIntoWorkplace(pageId, jumpActionsMapping.COPY_LAYER, skin)
            this.props.WPLayersStore.setSkinType(skin.skinType)
          }}
          onCancel={() => {
            this.setState({ typeVisible: false })
          }}
        />
        {visible && (
          <Modal
            title="加入协作"
            // eslint-disable-next-line react/jsx-boolean-value
            visible={true}
            onOk={this.addUser}
            onCancel={this.cancel}
          >
            <Select
              mode="multiple"
              value={value}
              placeholder="请输入加入协作人的姓名"
              notFoundContent={fetching ? <Spin size="small" /> : null}
              filterOption={false}
              onSearch={this.fetchUser}
              onChange={this.handleChange}
              style={{ width: '100%' }}
            >
              {data.map(d => (
                <Option key={d.adminId} value={d.adminId}>
                  {d.adminName}
                </Option>
              ))}
            </Select>
          </Modal>
        )}
        {templateVisible && (
          <Modal
            onOk={this.saveAsTemplate}
            visible
            title="保存模版"
            onCancel={() => {
              this.setState({
                templateVisible: false
              })
            }}
          >
            <Form>
              <Form.Item
                label="模版名称"
                labelCol={{ span: 4 }}
                wrapperCol={{ span: 14, offset: 1 }}
              >
                <Input
                  value={templateName}
                  onChange={e => {
                    this.setState({
                      templateName: e.target.value
                    })
                  }}
                />
              </Form.Item>
              <Form.Item
                label="模版描述"
                labelCol={{ span: 4 }}
                wrapperCol={{ span: 14, offset: 1 }}
              >
                <Input
                  value={desc}
                  onChange={e => {
                    this.setState({
                      desc: e.target.value
                    })
                  }}
                />
              </Form.Item>
            </Form>
          </Modal>
        )}
        <List
          className="homepage-list"
          itemLayout="vertical"
          size="large"
          pagination={{
            onChange: page => {
              this.props.onChange({
                currentPage: page
              })
            },
            showTotal: (total, page) => {
              return `${page} / ${total}`
            },
            pageSize: 10,
            showQuickJumper: true,
            size: 'large',
            total,
            current: current || 1
          }}
          dataSource={listData}
          renderItem={item => (
            <List.Item key={item.id}>
              <div className={styles['item']}>
                <div
                  className={styles['img']}
                  style={{ backgroundImage: `url("${item.image}")` }}
                />
                <div className={styles['main']}>
                  <div className={styles['top']}>
                    <span className={styles['id']}>
                      ID:
                      {item.id}
                    </span>
                    {item.ssoName && (
                      <div className={styles['author']}>
                        <TuiaIcon type="icon-system_founder" />
                        {item.ssoName}
                      </div>
                    )}
                  </div>
                  <div className={styles['middle']}>
                    <div>{item.skinName}</div>
                  </div>
                  <div className={styles['bottom']}>
                    类型：{skinTypeMap[item.skinType]}&nbsp;&nbsp;&nbsp;&nbsp;
                    标签：
                    {item.tagInfo &&
                      item.tagInfo.map(tag => (
                        <Tag key={tag.tagId} color="cyan">
                          {tag.tagName}
                        </Tag>
                      ))}
                  </div>
                </div>
                <div className={styles['control-bar']}>
                  {[
                    [
                      <div onClick={this.edit.bind(this, item.id)} key="edit">
                        编辑
                      </div>,
                      'layer/edit',
                      item.canEdit || isGod
                    ],
                    [
                      <PreviewH5
                        id={item.id}
                        title={item.title}
                        url={
                          location.origin + `/preview?id=${item.id}&type=layer`
                        }
                        content={({ show }) => <div onClick={show}>预览</div>}
                        type="layer"
                        key="preview"
                      />,
                      'layer/preview'
                    ],
                    [
                      <div onClick={this.copy.bind(this, item.id)} key="copy">
                        复制弹层
                      </div>,
                      'layer/copy'
                    ],
                    [
                      <div onClick={() => this.delete(item.id)} key="del">
                        删除
                      </div>,
                      'layer/del'
                    ],
                    [
                      <div
                        onClick={() =>
                          this.setState({
                            templateVisible: true,
                            item
                          })
                        }
                        key="setTemplate"
                      >
                        设为模版
                      </div>,
                      'layer/setTemplate'
                    ],
                    [
                      <div
                        onClick={() => this.addTeamWork(item.id)}
                        key="addPartner"
                      >
                        加入协作
                      </div>,
                      'layer/addPartner'
                    ]
                  ].map(([op, code, precondition]) => {
                    return (
                      (precondition === undefined || precondition) &&
                      permission.authRender(op, code)
                    )
                  })}
                  {/* <Button
                    size="small"
                    type="primary"
                    style={{
                      width: 80,
                      fontSize: 12,
                      lineHeight: '24px',
                      borderRadius: 4
                    }}
                    onClick={this.handlePreviewData.bind(this, item.id)}
                  >
                    查看数据
                  </Button> */}
                </div>
              </div>
            </List.Item>
          )}
        />
      </div>
    )
  }
}
