import common from 'layers/lib/common'

const prefix = '/java/layer'

export const getConditions = () => {
  return common.fetch(`${prefix}/conditions`, {}, 'get')
}

export const getPages = condition => {
  return common.fetch(`${prefix}/query`, { ...condition }, 'get', {
    isJson: true
  })
}
export const saveTemplate = data => {
  return common.fetch(`${prefix}/template/save`, data, 'post', {
    isJson: true
  })
}
export const getJson = id => {
  return new Promise(resolve => {
    common
      .fetch(`${prefix}/queryById`, {
        id
      })
      .then(res => {
        if (res.code === '0') {
          resolve({
            code: 0,
            data: {
              code: res.data.code
            }
          })
        }
      }, resolve)
      .catch(resolve)
  })
}
export const deleteByLandPageId = id => {
  return common.fetch(`/java/layer/save`, { id, isDeleted: 1 }, 'post', {
    isJson: true,
    isLoading: true
  })
}

export const searchUserByName = name => {
  return common.fetch(`/java/admin/name/match`, { name }, 'get')
}

export const permissionSave = (landPageId, adminId) => {
  return common.fetch(
    `/java/permission/save`,
    { landId: landPageId, adminId, scene: 1 },
    'post'
  )
}
export const listPermission = landPageId => {
  return common.fetch(
    `/java/land/listPermissionByScene`,
    { id: landPageId, scene: 1 },
    'get',
    {
      isLoading: true
    }
  )
}
