import 'braft-editor/dist/index.css'
import 'braft-extensions/dist/color-picker.css'
import React from 'react'
import BraftEditor from 'braft-editor'
import ColorPicker from 'braft-extensions/dist/color-picker'

BraftEditor.use(
  ColorPicker({
    // theme: 'light' // 支持dark和light两种主题，默认为dark
  })
)
export default class BasicDemo extends React.Component {
  state = {
    editorState: BraftEditor.createEditorState(this.props.value)
  }

  handleChange = editorState => {
    this.setState({
      editorState: editorState
    })
    this.props.onChange(editorState)
  }

  render() {
    const { editorState } = this.state
    return (
      <div>
        <div className="editor-wrapper">
          <BraftEditor
            {...this.props}
            value={editorState}
            onChange={this.handleChange}
          />
        </div>
      </div>
    )
  }
}
